/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeManagerImpl
implements ExtendedNodeTypeManager {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeTypeManagerImpl");
    public static final String NODETYPES_ROOT = "/jcr:system/jcr:nodetypes";
    protected final ValueFactory valueFactory;
    protected final LocationFactory locationFactory;
    protected final NodeTypeDataManager typesManager;
    protected final ItemDataConsumer dataManager;

    public NodeTypeManagerImpl(LocationFactory locationFactory, ValueFactoryImpl valueFactory, NodeTypeDataManager typesManager, ItemDataConsumer dataManager) {
        this.valueFactory = valueFactory;
        this.locationFactory = locationFactory;
        this.typesManager = typesManager;
        this.dataManager = dataManager;
    }

    @Override
    public NodeType findNodeType(InternalQName nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        NodeTypeData ntdata = this.typesManager.getNodeType(nodeTypeName);
        if (ntdata != null) {
            return new NodeTypeImpl(ntdata, this.typesManager, this, this.locationFactory, this.valueFactory, this.dataManager);
        }
        throw new NoSuchNodeTypeException("Nodetype not found " + nodeTypeName.getAsString());
    }

    public NodeTypeIterator getAllNodeTypes() {
        EntityCollection ec = new EntityCollection();
        List<NodeTypeData> allNts = this.typesManager.getAllNodeTypes();
        for (NodeTypeData ntdata : allNts) {
            ec.add(new NodeTypeImpl(ntdata, this.typesManager, this, this.locationFactory, this.valueFactory, this.dataManager));
        }
        return ec;
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        List<NodeTypeData> allNodeTypes = this.typesManager.getAllNodeTypes();
        Collections.sort(allNodeTypes, new NodeTypeDataComparator());
        EntityCollection ec = new EntityCollection();
        for (NodeTypeData nodeTypeData : allNodeTypes) {
            if (!nodeTypeData.isMixin()) continue;
            ec.add(new NodeTypeImpl(nodeTypeData, this.typesManager, this, this.locationFactory, this.valueFactory, this.dataManager));
        }
        return ec;
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        NodeTypeData ntdata = this.typesManager.getNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName());
        if (ntdata != null) {
            return new NodeTypeImpl(ntdata, this.typesManager, this, this.locationFactory, this.valueFactory, this.dataManager);
        }
        throw new NoSuchNodeTypeException("Nodetype not found " + nodeTypeName);
    }

    @Override
    public NodeTypeDataManager getNodeTypesHolder() throws RepositoryException {
        return this.typesManager;
    }

    @Override
    public NodeTypeValue getNodeTypeValue(String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        NodeTypeData ntdata = this.typesManager.getNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName());
        if (ntdata != null) {
            NodeTypeValue nodeTypeValue = new NodeTypeValue();
            nodeTypeValue.setMixin(ntdata.isMixin());
            nodeTypeValue.setName(this.locationFactory.createJCRName(ntdata.getName()).getAsString());
            nodeTypeValue.setOrderableChild(ntdata.hasOrderableChildNodes());
            if (ntdata.getPrimaryItemName() == null) {
                nodeTypeValue.setPrimaryItemName("");
            } else {
                nodeTypeValue.setPrimaryItemName(this.locationFactory.createJCRName(ntdata.getPrimaryItemName()).getAsString());
            }
            ArrayList<String> declaredSupertypeNames = new ArrayList<String>();
            for (int i = 0; i < ntdata.getDeclaredSupertypeNames().length; ++i) {
                declaredSupertypeNames.add(this.locationFactory.createJCRName(ntdata.getDeclaredSupertypeNames()[i]).getAsString());
            }
            ArrayList<PropertyDefinitionValue> declaredPropertyDefinitionValues = new ArrayList<PropertyDefinitionValue>();
            for (int i = 0; i < ntdata.getDeclaredPropertyDefinitions().length; ++i) {
                declaredPropertyDefinitionValues.add(this.convert(ntdata.getDeclaredPropertyDefinitions()[i]));
            }
            ArrayList<NodeDefinitionValue> declaredChildNodeDefinitionValues = new ArrayList<NodeDefinitionValue>();
            for (int i = 0; i < ntdata.getDeclaredChildNodeDefinitions().length; ++i) {
                declaredChildNodeDefinitionValues.add(this.convert(ntdata.getDeclaredChildNodeDefinitions()[i]));
            }
            nodeTypeValue.setDeclaredSupertypeNames(declaredSupertypeNames);
            nodeTypeValue.setDeclaredPropertyDefinitionValues(declaredPropertyDefinitionValues);
            nodeTypeValue.setDeclaredChildNodeDefinitionValues(declaredChildNodeDefinitionValues);
            return nodeTypeValue;
        }
        throw new NoSuchNodeTypeException("Nodetype not found " + nodeTypeName);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        EntityCollection ec = new EntityCollection();
        NodeTypeIterator allTypes = this.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType type = allTypes.nextNodeType();
            if (type.isMixin()) continue;
            ec.add(type);
        }
        return ec;
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        return this.typesManager.getNodeType(this.locationFactory.parseJCRName(name).getInternalName()) != null;
    }

    public void registerNodeType(NodeType nodeType, int alreadyExistsBehaviour) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeType registerNodeType(NodeTypeValue nodeTypeValue, int alreadyExistsBehaviour) throws RepositoryException {
        ArrayList<NodeTypeValue> list = new ArrayList<NodeTypeValue>();
        list.add(nodeTypeValue);
        NodeTypeIterator it = this.registerNodeTypes(list, alreadyExistsBehaviour);
        return it.nextNodeType();
    }

    @Override
    public NodeTypeIterator registerNodeTypes(List<NodeTypeValue> values, int alreadyExistsBehaviour) throws UnsupportedRepositoryOperationException, RepositoryException {
        List<NodeTypeData> nts = this.typesManager.registerNodeTypes(values, alreadyExistsBehaviour);
        EntityCollection types = new EntityCollection();
        for (NodeTypeData ntdata : nts) {
            types.add(new NodeTypeImpl(ntdata, this.typesManager, this, this.locationFactory, this.valueFactory, this.dataManager));
        }
        return types;
    }

    @Override
    public NodeTypeIterator registerNodeTypes(InputStream xml, int alreadyExistsBehaviour, String contentType) throws RepositoryException {
        List<NodeTypeData> nts = this.typesManager.registerNodeTypes(xml, alreadyExistsBehaviour, contentType);
        EntityCollection types = new EntityCollection();
        for (NodeTypeData ntdata : nts) {
            types.add(new NodeTypeImpl(ntdata, this.typesManager, this, this.locationFactory, this.valueFactory, this.dataManager));
        }
        return types;
    }

    @Override
    public void unregisterNodeType(String name) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        InternalQName nodeTypeName = this.locationFactory.parseJCRName(name).getInternalName();
        if (this.typesManager.getNodeType(nodeTypeName) == null) {
            throw new NoSuchNodeTypeException(name);
        }
        this.typesManager.unregisterNodeType(nodeTypeName);
    }

    @Override
    public void unregisterNodeTypes(String[] names) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        for (int i = 0; i < names.length; ++i) {
            this.unregisterNodeType(names[i]);
        }
    }

    private NodeDefinitionValue convert(NodeDefinitionData data) throws RepositoryException {
        NodeDefinitionValue value = new NodeDefinitionValue();
        value.setName(this.locationFactory.createJCRName(data.getName()).getAsString());
        value.setAutoCreate(data.isAutoCreated());
        value.setMandatory(data.isMandatory());
        value.setOnVersion(data.getOnParentVersion());
        value.setReadOnly(data.isProtected());
        value.setSameNameSiblings(data.isAllowsSameNameSiblings());
        value.setDefaultNodeTypeName(this.locationFactory.createJCRName(data.getDeclaringNodeType()).getAsString());
        ArrayList<String> requiredNodeTypeNames = new ArrayList<String>();
        for (int i = 0; i < data.getRequiredPrimaryTypes().length; ++i) {
            requiredNodeTypeNames.add(this.locationFactory.createJCRName(data.getRequiredPrimaryTypes()[i]).getAsString());
        }
        value.setRequiredNodeTypeNames(requiredNodeTypeNames);
        return value;
    }

    private PropertyDefinitionValue convert(PropertyDefinitionData data) throws RepositoryException {
        PropertyDefinitionValue value = new PropertyDefinitionValue();
        value.setName(this.locationFactory.createJCRName(data.getName()).getAsString());
        value.setAutoCreate(data.isAutoCreated());
        value.setMandatory(data.isMandatory());
        value.setOnVersion(data.getOnParentVersion());
        value.setReadOnly(data.isProtected());
        value.setRequiredType(data.getRequiredType());
        value.setMultiple(data.isMultiple());
        value.setDefaultValueStrings(Arrays.asList(data.getDefaultValues()));
        value.setValueConstraints(Arrays.asList(data.getValueConstraints()));
        return value;
    }

    private class NodeTypeDataComparator
    implements Comparator<NodeTypeData> {
        private static final int NT = 4;
        private static final int MIX = 3;
        private static final int JCR = 2;
        private static final int EXO = 1;
        private static final int OTHER = 0;

        private NodeTypeDataComparator() {
        }

        @Override
        public int compare(NodeTypeData o1, NodeTypeData o2) {
            return this.getIndex(o2) - this.getIndex(o1);
        }

        private int getIndex(NodeTypeData data) {
            int result = 0;
            InternalQName name = data.getName();
            String nameSpace = name.getNamespace();
            if ("http://www.jcp.org/jcr/nt/1.0".equals(nameSpace)) {
                result = 4;
            } else if ("http://www.jcp.org/jcr/mix/1.0".equals(nameSpace)) {
                result = 3;
            } else if ("http://www.jcp.org/jcr/1.0".equals(nameSpace)) {
                result = 2;
            } else if ("http://www.exoplatform.com/jcr/exo/1.0".equals(nameSpace)) {
                result = 1;
            }
            return result;
        }
    }
}

