/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.documents;

import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class IsAvailableDocumentProviderPresentFilter
extends UIExtensionAbstractFilter {
    private static final String MIX_REFERENCEABLE = "mix:referenceable";

    public IsAvailableDocumentProviderPresentFilter() {
        this(null);
    }

    public IsAvailableDocumentProviderPresentFilter(String messageKey) {
        super(messageKey, UIExtensionFilterType.MANDATORY);
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        DocumentService documentService;
        UIJCRExplorer uiExplorer;
        Node node = null;
        if (context != null) {
            node = (Node)context.get(Node.class.getName());
        }
        if (node == null && (uiExplorer = (UIJCRExplorer)((Object)context.get(UIJCRExplorer.class.getName()))) != null) {
            node = uiExplorer.getCurrentNode();
        }
        if (node != null && node.isNodeType(MIX_REFERENCEABLE) && (documentService = (DocumentService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(DocumentService.class)) != null) {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String fileId = node.getUUID();
            String workspace = node.getSession().getWorkspace().getName();
            for (DocumentEditorProvider provider : documentService.getDocumentEditorProviders()) {
                if (!provider.isAvailableForUser(identity) || !provider.isDocumentSupported(fileId, workspace)) continue;
                return true;
            }
        }
        return false;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

