/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.rest;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.rest.model.PollOptionRestEntity;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.RestEntityBuilder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

@Path(value="/v1/poll")
@Tag(name="/v1/poll", description="Managing poll")
public class PollRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PollRest.class);
    private PollService pollService;

    public PollRest(PollService pollService) {
        this.pollService = pollService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create a new poll", method="POST", description="Create a new poll")
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="50", description="Internal server error")})
    public Response createPoll(@Parameter(description="space identifier") @QueryParam(value="spaceId") String spaceId, @RequestBody(description="Poll object to create", required=true) PollRestEntity pollRestEntity) {
        if (pollRestEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Poll poll = RestEntityBuilder.toPoll(pollRestEntity);
            List<PollOption> pollOptions = RestEntityBuilder.toPollOptions(pollRestEntity.getOptions());
            poll = this.pollService.createPoll(poll, pollOptions, spaceId, pollRestEntity.getMessage(), currentIdentity, pollRestEntity.getFiles());
            return Response.ok((Object)poll).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create a non authorized poll", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating a poll ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get a poll", method="GET", description="This gets the poll with the given id if the authenticated user is a member of the space.")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Poll not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPollById(@Parameter(description="Poll id", required=true) @PathParam(value="id") String pollId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)pollId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Poll poll = this.pollService.getPollById(Long.parseLong(pollId), currentIdentity);
            if (poll == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List pollOptions = this.pollService.getPollOptionsByPollId(Long.parseLong(pollId), currentIdentity);
            ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
            for (PollOption pollOption : pollOptions) {
                int pollOptionVotes = this.pollService.getPollOptionTotalVotes(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                boolean isPollOptionVoted = this.pollService.isPollOptionVoted(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                PollOptionRestEntity pollOptionRestEntity = RestEntityBuilder.fromPollOption(pollOption, pollOptionVotes, isPollOptionVoted);
                pollOptionRestEntities.add(pollOptionRestEntity);
            }
            PollRestEntity pollRestEntity = RestEntityBuilder.fromPoll(poll, pollOptionRestEntities);
            return Response.ok((Object)pollRestEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to get a non authorized poll with id {}", new Object[]{currentIdentity.getUserId(), pollId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Error when getting a poll by id {} ", new Object[]{pollId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/vote/{optionId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Vote in a poll", method="POST", description="Vote in a poll")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Poll option not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response vote(@Parameter(description="Poll option id", required=true) @PathParam(value="optionId") String optionId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            PollOption pollOption = this.pollService.getPollOptionById(Long.parseLong(optionId), currentIdentity);
            if (pollOption == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Poll poll = this.pollService.getPollById(pollOption.getPollId(), currentIdentity);
            if (poll == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (this.pollService.didVote(currentIdentity, Long.valueOf(pollOption.getPollId()))) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User did already vote an option in this poll").build();
            }
            PollVote pollVote = this.pollService.vote(optionId, String.valueOf(poll.getSpaceId()), currentIdentity);
            return Response.ok((Object)pollVote).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to vote in a non authorized poll option with id {}", new Object[]{currentIdentity.getUserId(), optionId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Error when voting in the poll option id {}", new Object[]{optionId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

