/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.io.Serializable;
import org.exoplatform.web.application.CompoundApplicationMessage;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MultipleConditionsValidator;

public class ConfigurableIdentifierValidator
extends MultipleConditionsValidator
implements Serializable {
    protected static int DEFAULT_MIN_LENGTH = 3;
    protected static int DEFAULT_MAX_LENGTH = 30;
    protected Integer min = DEFAULT_MIN_LENGTH;
    protected Integer max = DEFAULT_MAX_LENGTH;
    protected static String IDENTIFER_VALIDATOR_REGEX = "^[\\p{L}_][\\p{L}\\d_-]*$";

    public ConfigurableIdentifierValidator() {
    }

    public ConfigurableIdentifierValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    static void validate(String value, String label, CompoundApplicationMessage messages, UIFormInput uiInput, Integer min, Integer max) {
        char[] buff = value.toCharArray();
        if (buff.length < min || buff.length > max) {
            messages.addMessage("StringLengthValidator.msg.length-invalid", new Object[]{label, min.toString(), max.toString()});
        }
        if (Character.isDigit(value.charAt(0)) || value.charAt(0) == '-') {
            messages.addMessage("FirstAndSpecialCharacterNameValidator.msg", new Object[]{label, uiInput.getBindingField()});
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') continue;
            messages.addMessage("IdentifierValidator.msg.Invalid-char", new Object[]{label});
            break;
        }
    }

    @Override
    protected void validate(String value, String label, CompoundApplicationMessage messages, UIFormInput uiInput) {
        ConfigurableIdentifierValidator.validate(value, label, messages, uiInput, this.min, this.max);
    }
}

