/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Locale;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.measure.ValueRange;
import org.opengis.util.InternationalString;

final class DomainRange<E extends Number>
extends NumberRange<E>
implements InternationalString {
    private static final long serialVersionUID = 702771264296112914L;
    private volatile transient String text;

    DomainRange(Class<E> clazz, ValueRange valueRange) throws IllegalArgumentException {
        super(clazz, valueRange);
    }

    public String toString(Locale locale) {
        if (locale == null || locale == Locale.ROOT) {
            return this.toString();
        }
        RangeFormat rangeFormat = new RangeFormat(locale, this.getElementType());
        return rangeFormat.format((Object)this);
    }

    public String toString() {
        String string = this.text;
        if (string == null) {
            this.text = string = super.toString();
        }
        return string;
    }

    public int length() {
        return this.toString().length();
    }

    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    public int compareTo(InternationalString internationalString) {
        if (internationalString instanceof DomainRange) {
            return this.compareTo((DomainRange)internationalString);
        }
        return this.toString().compareTo(internationalString.toString());
    }

    private int compareTo(DomainRange<?> domainRange) {
        int n = Double.compare(this.getMinDouble(), domainRange.getMinDouble());
        if (n == 0) {
            boolean bl = this.isMinIncluded();
            if (bl != domainRange.isMinIncluded()) {
                n = bl ? -1 : 1;
            } else {
                n = Double.compare(this.getMaxDouble(), domainRange.getMaxDouble());
                if (n == 0 && (bl = this.isMaxIncluded()) != domainRange.isMaxIncluded()) {
                    n = bl ? 1 : -1;
                }
            }
        }
        return n;
    }
}

