/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.listener;

import io.meeds.poll.model.Poll;
import java.util.HashMap;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class GamificationPollListener
extends Listener<String, Poll> {
    private static final Log LOG = ExoLogger.getLogger(GamificationPollListener.class);
    private IdentityManager identityManager;
    private ListenerService listenerService;

    public GamificationPollListener(IdentityManager identityManager, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<String, Poll> event) throws Exception {
        Poll poll = (Poll)event.getData();
        String activityId = String.valueOf(poll.getActivityId());
        String creatorIdentityId = String.valueOf(poll.getCreatorId());
        if (event.getEventName().equals("meeds.poll.createPoll")) {
            this.createRealizations("createPoll", activityId, creatorIdentityId, creatorIdentityId);
        } else if (event.getEventName().equals("meeds.poll.votePoll")) {
            Identity identity = this.identityManager.getOrCreateUserIdentity((String)event.getSource());
            this.createRealizations("votePoll", activityId, identity.getId(), creatorIdentityId);
            this.createRealizations("receivePollVote", activityId, creatorIdentityId, identity.getId());
        }
    }

    private void createRealizations(String gamificationEventName, String activityId, String earnerUsername, String receiverUsername) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectType", "activity");
            gam.put("objectId", activityId);
            gam.put("senderType", "organization");
            gam.put("senderId", earnerUsername);
            gam.put("receiverType", "organization");
            gam.put("receiverId", receiverUsername);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }
}

