/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;

public class ApplicationCategoriesPlugins
extends BaseComponentPlugin {
    private ConfigurationManager cmanager_;
    private ApplicationRegistryService pdcService_;
    private List<ApplicationCategory> categories;
    private boolean merge;
    private boolean system;

    public ApplicationCategoriesPlugins(ApplicationRegistryService pdcService, ConfigurationManager cmanager, InitParams params) throws Exception {
        this.categories = params.getObjectParamValues(ApplicationCategory.class);
        if (params.containsKey((Object)"merge")) {
            this.merge = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)params.getValueParam("merge").getValue());
        }
        if (params.containsKey((Object)"system")) {
            this.system = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)params.getValueParam("system").getValue());
        }
        this.cmanager_ = cmanager;
        this.pdcService_ = pdcService;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void run() throws Exception {
        this.run(false);
    }

    public List<ApplicationCategory> getCategories() {
        return this.categories;
    }

    public void run(boolean firstStartup) throws Exception {
        if (this.categories == null || !firstStartup && !this.merge && !this.system) {
            return;
        }
        for (ApplicationCategory category : this.categories) {
            ApplicationCategory storedCategory = this.pdcService_.getApplicationCategory(category.getName());
            List<Application> apps = category.getApplications();
            if (storedCategory == null) {
                this.pdcService_.save(category);
            }
            if (firstStartup || storedCategory == null) {
                for (Application app : apps) {
                    this.pdcService_.save(category, app);
                }
                continue;
            }
            if (!this.system) continue;
            for (Application app : apps) {
                Application storedApplication = this.pdcService_.getApplication(category.getName() + "/" + app.getApplicationName());
                if (storedApplication != null) continue;
                this.pdcService_.save(category, app);
            }
        }
    }
}

