/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.storage;

import io.meeds.social.link.constant.LinkDisplayType;
import io.meeds.social.link.dao.LinkDAO;
import io.meeds.social.link.dao.LinkSettingDAO;
import io.meeds.social.link.entity.LinkEntity;
import io.meeds.social.link.entity.LinkSettingEntity;
import io.meeds.social.link.model.Link;
import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.storage.util.EntityMapper;
import java.time.Instant;
import java.util.List;

public class LinkStorage {
    private LinkSettingDAO linkSettingDAO;
    private LinkDAO linkDAO;

    public LinkStorage(LinkSettingDAO linkSettingDAO, LinkDAO linkDAO) {
        this.linkSettingDAO = linkSettingDAO;
        this.linkDAO = linkDAO;
    }

    public LinkSetting getLinkSetting(String name) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(name);
        return EntityMapper.toModel(linkSettingEntity);
    }

    public LinkSetting getLinkSetting(Long linkSettingId) {
        LinkSettingEntity linkSettingEntity = (LinkSettingEntity)this.linkSettingDAO.find(linkSettingId);
        return EntityMapper.toModel(linkSettingEntity);
    }

    public boolean hasLinkSetting(String linkSettingName) {
        return this.getLinkSetting(linkSettingName) != null;
    }

    public LinkSetting initLinkSetting(String name, String pageReference, long spaceId) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(name);
        if (linkSettingEntity == null) {
            linkSettingEntity = new LinkSettingEntity();
            linkSettingEntity.setName(name);
            linkSettingEntity.setPageReference(pageReference);
            linkSettingEntity.setSpaceId(spaceId);
            linkSettingEntity.setType(LinkDisplayType.ROW);
            linkSettingEntity.setLastModified(Instant.now());
            return EntityMapper.toModel((LinkSettingEntity)this.linkSettingDAO.create(linkSettingEntity));
        }
        linkSettingEntity.setPageReference(pageReference);
        return EntityMapper.toModel((LinkSettingEntity)this.linkSettingDAO.update(linkSettingEntity));
    }

    public LinkSetting saveLinkSetting(LinkSetting linkSetting) {
        LinkSettingEntity existingLinkSettingEntity = this.linkSettingDAO.findByName(linkSetting.getName());
        LinkSettingEntity linkSettingEntity = EntityMapper.fromModel(linkSetting, existingLinkSettingEntity);
        return EntityMapper.toModel((LinkSettingEntity)this.linkSettingDAO.update(linkSettingEntity));
    }

    public List<Link> getLinks(String linkSettingName) {
        List<LinkEntity> linkEntities = this.linkDAO.getLinks(linkSettingName);
        return linkEntities.stream().map(EntityMapper::toModel).toList();
    }

    public Link createLink(String linkSettingName, Link link) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(linkSettingName);
        LinkEntity linkEntity = EntityMapper.fromModel(link, linkSettingEntity);
        linkEntity.setId(null);
        linkEntity = (LinkEntity)this.linkDAO.create(linkEntity);
        this.updateLastModifiedTime(linkSettingEntity);
        return EntityMapper.toModel(linkEntity);
    }

    public Link updateLink(String linkSettingName, Link link) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(linkSettingName);
        LinkEntity linkEntity = EntityMapper.fromModel(link, linkSettingEntity);
        linkEntity = (LinkEntity)this.linkDAO.update(linkEntity);
        this.updateLastModifiedTime(linkSettingEntity);
        return EntityMapper.toModel(linkEntity);
    }

    public void deleteLink(String linkSettingName, long id) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(linkSettingName);
        LinkEntity linkEntity = (LinkEntity)this.linkDAO.find(Long.valueOf(id));
        this.linkDAO.delete(linkEntity);
        this.updateLastModifiedTime(linkSettingEntity);
    }

    private void updateLastModifiedTime(LinkSettingEntity linkSettingEntity) {
        linkSettingEntity.setLastModified(Instant.now());
        this.linkSettingDAO.update(linkSettingEntity);
    }

    public LinkSetting getLinkSettingByLinkId(long linkId) {
        long linkSettingId = this.linkDAO.getLinkSettingByLinkId(linkId);
        return this.getLinkSetting(linkSettingId);
    }
}

