/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.attachment.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.metadata.thumbnail.ImageThumbnailService;

public class FileAttachmentStorage {
    private static final Log LOG = ExoLogger.getLogger(FileAttachmentStorage.class);
    private static final String FILE_API_NAMESPACE = "attachment";
    private FileService fileService;
    private ImageThumbnailService imageThumbnailService;

    public FileAttachmentStorage(FileService fileService, ImageThumbnailService imageThumbnailService) {
        this.fileService = fileService;
        this.imageThumbnailService = imageThumbnailService;
    }

    public String uploadAttachment(Long attachmentId, String objectType, String objectId, String fileName, String fileMimeType, InputStream fileInputStream, long userIdentityId) throws IOException {
        try {
            FileItem fileItem = new FileItem(attachmentId, fileName, fileMimeType, FILE_API_NAMESPACE, (long)fileInputStream.available(), new Date(), String.valueOf(userIdentityId), false, fileInputStream);
            fileItem = attachmentId == null ? this.fileService.writeFile(fileItem) : this.fileService.updateFile(fileItem);
            return String.valueOf(fileItem.getFileInfo().getId());
        }
        catch (Exception e) {
            throw new IOException("Error attaching file " + fileName + " to object " + objectType + "/" + objectId, e);
        }
    }

    public ObjectAttachmentDetail getAttachment(ObjectAttachmentId attachmentId) {
        FileInfo fileInfo = this.fileService.getFileInfo(Long.parseLong(attachmentId.getFileId()));
        if (fileInfo != null && !fileInfo.isDeleted()) {
            return new ObjectAttachmentDetail(String.valueOf(fileInfo.getId()), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate().getTime(), fileInfo.getUpdater());
        }
        return null;
    }

    public InputStream getAttachmentInputStream(ObjectAttachmentId attachmentId, String imageDimensions, Identity userIdentity) throws IOException {
        FileItem fileItem;
        long fileId = Long.parseLong(attachmentId.getFileId());
        FileInfo fileInfo = this.fileService.getFileInfo(fileId);
        if (fileInfo == null) {
            throw new IOException("Attached file with id " + attachmentId + " wasn't found");
        }
        try {
            fileItem = this.fileService.getFile(fileId);
        }
        catch (FileStorageException e) {
            throw new IOException("Error reading file with id " + fileId, e);
        }
        if (StringUtils.contains((CharSequence)fileInfo.getMimetype(), (CharSequence)"image/") && StringUtils.isNotBlank((CharSequence)imageDimensions)) {
            int[] dimension = Utils.parseDimension((String)imageDimensions);
            try {
                FileItem imageFileItem = this.imageThumbnailService.getOrCreateThumbnail(fileItem, userIdentity, dimension[0], dimension[1]);
                return imageFileItem.getAsStream();
            }
            catch (Exception e) {
                LOG.warn("Error while resizing attachment with Id {}, original Image will be returned", new Object[]{fileId, e});
                return fileItem.getAsStream();
            }
        }
        return fileItem.getAsStream();
    }

    public void deleteAttachment(ObjectAttachmentId objectAttachmentId) throws IOException {
        long fileId = Long.parseLong(objectAttachmentId.getFileId());
        try {
            FileItem fileItem = this.fileService.getFile(fileId);
            if (fileItem != null) {
                this.fileService.deleteFile(fileId);
            }
        }
        catch (FileStorageException e) {
            throw new IOException("Error deleting attached file " + objectAttachmentId, e);
        }
    }
}

