/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.feature.CharacteristicMap;
import org.apache.sis.feature.CharacteristicTypeMap;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.MultiValuedAttribute;
import org.apache.sis.feature.SingletonAttribute;
import org.apache.sis.feature.Validator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;

public abstract class AbstractAttribute<V>
extends Field<V>
implements Serializable {
    private static final long serialVersionUID = 7442739120526654676L;
    final DefaultAttributeType<V> type;
    private transient Map<String, AbstractAttribute<?>> characteristics;

    protected AbstractAttribute(DefaultAttributeType<V> defaultAttributeType) {
        this.type = defaultAttributeType;
    }

    public static <V> AbstractAttribute<V> create(DefaultAttributeType<V> defaultAttributeType) {
        ArgumentChecks.ensureNonNull((String)"type", defaultAttributeType);
        return AbstractAttribute.isSingleton(defaultAttributeType.getMaximumOccurs()) ? new SingletonAttribute<V>(defaultAttributeType) : new MultiValuedAttribute<V>(defaultAttributeType);
    }

    static <V> AbstractAttribute<V> create(DefaultAttributeType<V> defaultAttributeType, Object object) {
        ArgumentChecks.ensureNonNull((String)"type", defaultAttributeType);
        return AbstractAttribute.isSingleton(defaultAttributeType.getMaximumOccurs()) ? new SingletonAttribute<V>(defaultAttributeType, object) : new MultiValuedAttribute<V>(defaultAttributeType, object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AbstractAttribute[] abstractAttributeArray = this.characteristics instanceof CharacteristicMap ? this.characteristics.values().toArray(new AbstractAttribute[this.characteristics.size()]) : null;
        objectOutputStream.writeObject(abstractAttributeArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            AbstractAttribute[] abstractAttributeArray = (AbstractAttribute[])objectInputStream.readObject();
            if (abstractAttributeArray != null) {
                this.characteristics = this.newCharacteristicsMap();
                this.characteristics.values().addAll(Arrays.asList(abstractAttributeArray));
            }
        }
        catch (RuntimeException runtimeException) {
            throw (IOException)new InvalidObjectException(runtimeException.getLocalizedMessage()).initCause(runtimeException);
        }
    }

    @Override
    public GenericName getName() {
        return this.type.getName();
    }

    public DefaultAttributeType<V> getType() {
        return this.type;
    }

    @Override
    public abstract V getValue() throws IllegalStateException;

    @Override
    public Collection<V> getValues() {
        return super.getValues();
    }

    @Override
    public abstract void setValue(V var1) throws IllegalArgumentException;

    @Override
    public void setValues(Collection<? extends V> collection) throws IllegalArgumentException {
        super.setValues(collection);
    }

    public Map<String, AbstractAttribute<?>> characteristics() {
        if (this.characteristics == null) {
            this.characteristics = this.newCharacteristicsMap();
        }
        return this.characteristics;
    }

    private Map<String, AbstractAttribute<?>> newCharacteristicsMap() {
        Object object;
        if (this.type instanceof DefaultAttributeType && !(object = this.type.characteristics()).isEmpty()) {
            if (!(object instanceof CharacteristicTypeMap)) {
                Collection<DefaultAttributeType<?>> collection = object.values();
                object = CharacteristicTypeMap.create(this.type, collection.toArray(new DefaultAttributeType[collection.size()]));
            }
            return new CharacteristicMap(this, (CharacteristicTypeMap)((Object)object));
        }
        return Collections.emptyMap();
    }

    final Map<String, AbstractAttribute<?>> characteristicsReadOnly() {
        return this.characteristics != null ? this.characteristics : Collections.emptyMap();
    }

    public DataQuality quality() {
        Validator validator = new Validator(ScopeCode.ATTRIBUTE);
        validator.validate(this.type, this.getValues());
        return validator.quality;
    }

    public String toString() {
        StringBuilder stringBuilder = FieldType.toString(AbstractAttribute.isDeprecated(this.type), "Attribute", this.type.getName(), Classes.getShortName(this.type.getValueClass()), this.getValues().iterator());
        if (this.characteristics != null && !this.characteristics.isEmpty()) {
            stringBuilder.append(System.lineSeparator());
            String string = "\u2514\u2500 characteristics: ";
            for (Map.Entry<String, AbstractAttribute<?>> entry : this.characteristics.entrySet()) {
                stringBuilder.append(string).append(entry.getKey()).append('=').append(entry.getValue().getValue());
                string = ", ";
            }
        }
        return stringBuilder.toString();
    }

    public AbstractAttribute<V> clone() throws CloneNotSupportedException {
        AbstractAttribute abstractAttribute = (AbstractAttribute)super.clone();
        Map<String, AbstractAttribute<?>> map = abstractAttribute.characteristics;
        if (map instanceof CharacteristicMap) {
            abstractAttribute.characteristics = ((CharacteristicMap)((Object)map)).clone();
        }
        return abstractAttribute;
    }
}

