/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.operation.Matrix;

public final class AnnotatedMatrix
implements Matrix,
Cloneable {
    private final Matrix matrix;
    public final PositionalAccuracy accuracy;

    private AnnotatedMatrix(Matrix matrix, PositionalAccuracy positionalAccuracy) {
        this.matrix = matrix;
        this.accuracy = positionalAccuracy;
    }

    public static Matrix indirect(Matrix matrix, boolean bl) {
        return new AnnotatedMatrix(matrix, bl ? PositionalAccuracyConstant.INDIRECT_SHIFT_APPLIED : PositionalAccuracyConstant.DATUM_SHIFT_OMITTED);
    }

    public int getNumRow() {
        return this.matrix.getNumRow();
    }

    public int getNumCol() {
        return this.matrix.getNumCol();
    }

    public boolean isIdentity() {
        return this.matrix.isIdentity();
    }

    public double getElement(int n, int n2) {
        return this.matrix.getElement(n, n2);
    }

    public void setElement(int n, int n2, double d) {
        this.matrix.setElement(n, n2, d);
    }

    public Matrix clone() {
        return new AnnotatedMatrix(this.matrix.clone(), this.accuracy);
    }

    public boolean equals(Object object) {
        if (object instanceof AnnotatedMatrix) {
            AnnotatedMatrix annotatedMatrix = (AnnotatedMatrix)object;
            return this.matrix.equals((Object)annotatedMatrix.matrix) && this.accuracy.equals((Object)annotatedMatrix.accuracy);
        }
        return false;
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    public String toString() {
        return this.matrix.toString();
    }
}

