/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.opengis.referencing.IdentifiedObject;

final class ReferenceKeeper {
    private static final int CAPACITY = 40;
    private static final long EXPIRATION_TIME = 300000000000L;
    private IdentifiedObject[] cache;
    private long[] timestamps;
    private int indexOfLast;
    private boolean hasCleanerTask;

    ReferenceKeeper() {
    }

    final synchronized void markAsUsed(IdentifiedObject identifiedObject) {
        if (this.cache == null) {
            this.cache = new IdentifiedObject[40];
            this.timestamps = new long[40];
        }
        Long l = System.nanoTime();
        if (this.cache[this.indexOfLast] != identifiedObject && ++this.indexOfLast >= 40) {
            this.indexOfLast = 0;
        }
        this.cache[this.indexOfLast] = identifiedObject;
        this.timestamps[this.indexOfLast] = l;
        if (!this.hasCleanerTask) {
            this.scheduleCleanerTask(l);
        }
    }

    private void scheduleCleanerTask(long l) {
        DelayedExecutor.schedule((DelayedRunnable)new DelayedRunnable(l + 300000000000L){

            public void run() {
                ReferenceKeeper.this.clearExpiredEntries();
            }
        });
        this.hasCleanerTask = true;
    }

    private synchronized void clearExpiredEntries() {
        this.hasCleanerTask = false;
        boolean bl = true;
        long l = System.nanoTime();
        for (int i = 0; i < 40; ++i) {
            if (l - this.timestamps[i] >= 300000000000L) {
                this.cache[i] = null;
                continue;
            }
            bl &= this.cache[i] == null;
        }
        if (bl) {
            this.cache = null;
            this.timestamps = null;
        } else {
            this.scheduleCleanerTask(l);
        }
    }
}

