/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.externalstore;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.externalstore.IDMQueueService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.externalstore.model.IDMQueueEntry;

public class IDMInMemoryQueueServiceImpl
implements IDMQueueService {
    private static final Log LOG = ExoLogger.getLogger(IDMInMemoryQueueServiceImpl.class);
    private static final String IDM_QUEUE_PROCESSING_MAX_RETRIES = "exo.idm.queue.processing.error.retries.max";
    private static final int DEFAULT_MAX_RETRIES = 5;
    private Map<IDMEntityType<?>, LocalDateTime> lastSuccessTimeByEntityType = new HashMap();
    private List<IDMQueueEntry> queue = Collections.synchronizedList(new ArrayList());
    private int maxRetries = 5;

    public IDMInMemoryQueueServiceImpl(InitParams params) {
        if (params != null && params.containsKey((Object)IDM_QUEUE_PROCESSING_MAX_RETRIES)) {
            String maxRetriesString = params.getValueParam(IDM_QUEUE_PROCESSING_MAX_RETRIES).getValue();
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse max retries " + maxRetriesString + ". Default value 5 will be used"), (Throwable)e);
            }
        }
    }

    public LocalDateTime getLastCheckedTime(IDMEntityType<?> entityType) {
        return this.lastSuccessTimeByEntityType.get(entityType);
    }

    public void setLastCheckedTime(IDMEntityType<?> entityType, LocalDateTime dateTime) {
        this.lastSuccessTimeByEntityType.put(entityType, dateTime);
    }

    public int countAll() throws Exception {
        return (int)this.queue.stream().filter(entry -> !entry.isProcessed() && entry.getRetryCount() < this.getMaxRetries()).count();
    }

    public int count(int nbRetries) throws Exception {
        return (int)this.queue.stream().filter(entry -> !entry.isProcessed() && entry.getRetryCount() == nbRetries).count();
    }

    public void push(IDMQueueEntry object) throws Exception {
        this.queue.add(0, object);
    }

    public List<IDMQueueEntry> pop(int limit, int nbRetries, boolean keepInQueue) throws Exception {
        if (this.queue.size() == 0) {
            return Collections.emptyList();
        }
        List<IDMQueueEntry> entries = this.queue.stream().filter(entry -> !entry.isProcessed() && entry.getRetryCount() == nbRetries).limit(limit).collect(Collectors.toList());
        if (!keepInQueue) {
            this.queue.removeAll(entries);
        }
        return entries;
    }

    public void storeAsProcessed(List<IDMQueueEntry> queueEntries) {
        for (IDMQueueEntry queueEntry : queueEntries) {
            queueEntry.setProcessed(true);
        }
    }

    public void incrementRetry(List<IDMQueueEntry> queueEntries) {
        for (IDMQueueEntry queueEntry : queueEntries) {
            queueEntry.setRetryCount(queueEntry.getRetryCount() + 1);
        }
    }

    public void deleteProcessedEntries() {
        List processedElements = this.queue.stream().filter(entry -> entry.isProcessed()).collect(Collectors.toList());
        this.queue.removeAll(processedElements);
    }

    public void deleteExceededRetriesEntries() {
        List processedElements = this.queue.stream().filter(entry -> entry.getRetryCount() >= this.getMaxRetries()).collect(Collectors.toList());
        this.queue.removeAll(processedElements);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }
}

