/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;

public class WikiSpaceActivityPublisher
extends PageWikiListener {
    public static final String WIKI_APP_ID = "ks-wiki:spaces";
    public static final String ACTIVITY_TYPE_KEY = "act_key";
    public static final String PAGE_ID_KEY = "page_id";
    public static final String PAGE_TYPE_KEY = "page_type";
    public static final String PAGE_OWNER_KEY = "page_owner";
    public static final String PAGE_TITLE_KEY = "page_name";
    public static final String URL_KEY = "page_url";
    public static final String PAGE_EXCERPT = "page_exceprt";
    public static final String VIEW_CHANGE_URL_KEY = "view_change_url";
    public static final String VIEW_CHANGE_ANCHOR = "#CompareRevision/changes";
    public static final String WIKI_PAGE_NAME = "wiki";
    public static final String WIKI_PAGE_VERSION = "version";
    private static final int EXCERPT_LENGTH = 500;
    private static final Log LOG = ExoLogger.getExoLogger(WikiSpaceActivityPublisher.class);
    private NoteService noteService;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;

    public WikiSpaceActivityPublisher(NoteService noteService, IdentityManager identityManager, ActivityManager activityManager, SpaceService spaceService) {
        this.noteService = noteService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
    }

    private ExoSocialActivityImpl createNewActivity(String ownerId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(ownerId);
        activity.setBody("body");
        activity.setType(WIKI_APP_ID);
        return activity;
    }

    private ExoSocialActivity generateActivity(Identity ownerStream, Identity ownerIdentity, String wikiType, String wikiOwner, String pageId, Page page, String spaceUrl, String spaceName, PageUpdateType activityType) throws WikiException {
        ExoSocialActivity activity = null;
        boolean isNewActivity = true;
        if (page.getActivityId() != null) {
            activity = this.activityManager.getActivity(page.getActivityId());
            boolean bl = isNewActivity = activity == null;
        }
        if (isNewActivity && !page.isToBePublished()) {
            return null;
        }
        if (isNewActivity) {
            if (page.isMinorEdit()) {
                return null;
            }
            activity = this.createNewActivity(ownerIdentity.getId());
        }
        activity.setTitle(page.getTitle());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(PAGE_ID_KEY, pageId);
        templateParams.put(ACTIVITY_TYPE_KEY, activityType.toString());
        templateParams.put(PAGE_OWNER_KEY, wikiOwner);
        templateParams.put(PAGE_TYPE_KEY, wikiType);
        templateParams.put(PAGE_TITLE_KEY, page.getTitle());
        String pageURL = page.getUrl() == null ? (spaceUrl != null ? spaceUrl + "/wiki" : "") : page.getUrl();
        templateParams.put(URL_KEY, pageURL);
        int versionsTotal = 0;
        List versions = this.noteService.getVersionsHistoryOfNote(page, "");
        if (versions != null && !versions.isEmpty()) {
            versionsTotal = versions.size();
        }
        templateParams.put(WIKI_PAGE_VERSION, String.valueOf(versionsTotal));
        activity.setMetadataObjectType("notes");
        activity.setMetadataObjectId(page.getId());
        StringBuilder excerpt = new StringBuilder();
        try {
            excerpt.append(this.noteService.getNoteRenderedContent(page));
        }
        catch (Exception e) {
            throw new WikiException("Cannot render page " + page.getWikiType() + ":" + page.getWikiOwner() + page.getName(), (Throwable)e);
        }
        if (excerpt.length() > 500) {
            excerpt.replace(500, excerpt.length(), "...");
        }
        templateParams.put(PAGE_EXCERPT, this.validateExcerpt(excerpt.toString()));
        templateParams.put("registeredKeysForProcessor", PAGE_EXCERPT);
        if (!PageUpdateType.ADD_PAGE.equals((Object)activityType)) {
            String verName = null;
            if (versions != null && !versions.isEmpty()) {
                verName = String.valueOf(versions.size() + 1);
            }
            templateParams.put(VIEW_CHANGE_URL_KEY, Utils.getURL((String)page.getUrl(), verName));
        }
        activity.setTemplateParams(templateParams);
        if (isNewActivity) {
            this.activityManager.saveActivityNoReturn(ownerStream, activity);
        } else {
            if (PageUpdateType.MOVE_PAGE.equals((Object)activityType)) {
                activity.setStreamOwner(ownerStream.getRemoteId());
            }
            if (page.isToBePublished()) {
                activity.setUpdated(Long.valueOf(new Date().getTime()));
            }
            this.activityManager.updateActivity(activity, page.isToBePublished());
        }
        return activity;
    }

    private String validateExcerpt(String excerpt) {
        List lines = Stream.of(excerpt.split("\n")).filter(line -> !line.trim().isEmpty()).collect(Collectors.toList());
        Stream sLines = lines.stream();
        StringBuilder result = new StringBuilder();
        sLines.map(new Function<String, String>(){

            @Override
            public String apply(String line) {
                if (((String)line).length() > 500) {
                    line = ((String)line).substring(0, 500) + "...";
                }
                return line;
            }
        }).limit(4L).forEach(line -> {
            result.append("<p>");
            result.append((String)line);
            result.append("</p>");
        });
        if (lines.size() > 4) {
            result.append("...");
        }
        return result.toString();
    }

    private boolean isPublic(Page page) {
        List permissions = page.getPermissions();
        boolean isPublic = false;
        if (permissions != null) {
            block0: for (PermissionEntry permissionEntry : permissions) {
                if (!permissionEntry.getId().equals(IdentityConstants.ANY)) continue;
                for (Permission permission : permissionEntry.getPermissions()) {
                    if (!PermissionType.VIEWPAGE.equals((Object)permission.getPermissionType())) continue;
                    isPublic = true;
                    continue block0;
                }
            }
        }
        return isPublic;
    }

    private boolean isPublicInSpace(Page page, Space space) {
        List pagePermissions = page.getPermissions();
        String groupMemberShip = "*:" + space.getGroupId();
        boolean isPublic = false;
        if (pagePermissions != null) {
            for (PermissionEntry permissionEntry : pagePermissions) {
                IDType permissionIDType = permissionEntry.getIdType();
                String permissionId = permissionEntry.getId();
                if ((!permissionIDType.equals((Object)IDType.MEMBERSHIP) || !permissionId.equals(groupMemberShip)) && (!permissionIDType.equals((Object)IDType.GROUP) || !permissionId.equals(space.getGroupId()))) continue;
                isPublic = true;
                break;
            }
        }
        return isPublic;
    }

    protected void saveActivity(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType activityType) throws WikiException {
        String spaceName;
        String spaceUrl;
        ExoSocialActivity activity;
        Identity ownerStream;
        Identity userIdentity;
        block7: {
            if (!PortalConfig.GROUP_TYPE.equals(wikiType)) {
                return;
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            userIdentity = this.identityManager.getOrCreateUserIdentity(username);
            ownerStream = null;
            activity = null;
            spaceUrl = null;
            spaceName = null;
            try {
                Space space = this.spaceService.getSpaceByGroupId(wikiOwner);
                if (space != null) {
                    ownerStream = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
                    spaceUrl = space.getUrl();
                    spaceName = space.getDisplayName();
                }
            }
            catch (SpaceStorageException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)String.format("Space %s not existed", wikiOwner), (Throwable)e);
            }
        }
        if (ownerStream != null) {
            activity = this.generateActivity(ownerStream, userIdentity, wikiType, wikiOwner, pageId, page, spaceUrl, spaceName, activityType);
            if (activity == null) {
                return;
            }
            String activityId = activity.getId();
            if (!StringUtils.isEmpty((String)activityId)) {
                page.setActivityId(activityId);
                this.noteService.updateNote(page);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if ("Home".equals(pageId) || !page.getWikiType().toUpperCase().equals(WikiType.GROUP.name()) || !page.isToBePublished()) {
            return;
        }
        this.saveActivity(wikiType, wikiOwner, pageId, page, PageUpdateType.ADD_PAGE);
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if (page.getActivityId() != null && StringUtils.isNotEmpty((String)page.getActivityId())) {
            this.activityManager.deleteActivity(page.getActivityId());
        }
    }

    public void postgetPagefromTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postgetPagefromBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (page != null && wikiUpdateType != null) {
            this.saveActivity(wikiType, wikiOwner, pageId, page, wikiUpdateType);
        }
    }
}

