/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.wci.security.Credentials;

public class ConversationStateUpdateFilter
extends AbstractFilter {
    private static final Log log = ExoLogger.getLogger(ConversationStateUpdateFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request;
        AuthenticationRegistry authRegistry = (AuthenticationRegistry)this.getContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
        if (hreq.getRemoteUser() != null && authRegistry.getCredentials(hreq) != null) {
            Credentials credentials = authRegistry.removeCredentials(hreq);
            this.bindCredentialsToConversationState(credentials);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected void bindCredentialsToConversationState(Credentials credentials) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        if (currentConversationState != null && credentials != null) {
            log.debug((Object)("Binding credentials to conversationState for user " + credentials.getUsername()));
            currentConversationState.setAttribute("credentials", (Object)credentials);
        }
    }
}

