/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalConfigImporter {
    private static final Log LOG = ExoLogger.getLogger(PortalConfigImporter.class);
    private final PortalConfig src;
    private final LayoutService service;
    private final ImportMode mode;

    public PortalConfigImporter(ImportMode importMode, PortalConfig portal, LayoutService dataStorage_) {
        this.mode = importMode;
        this.src = portal;
        this.service = dataStorage_;
    }

    public void perform() throws Exception {
        PortalConfig existingPortalConfig = this.service.getPortalConfig(this.src.getType(), this.src.getName());
        PortalConfig dst = null;
        boolean portalNotExists = existingPortalConfig == null;
        switch (this.mode) {
            case CONSERVE: 
            case INSERT: {
                if (portalNotExists) {
                    dst = this.src;
                    break;
                }
                dst = null;
                break;
            }
            case MERGE: 
            case OVERWRITE: {
                dst = this.src;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (dst != null) {
            LOG.info("Importing Portal config of site of type '{}' with name '{}', import mode '{}', already exists = {}", new Object[]{this.src.getType(), this.src.getName(), this.mode, !portalNotExists});
            if (portalNotExists) {
                this.service.create(dst);
            } else {
                this.service.save(dst);
            }
        }
    }
}

