/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.common;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gatein.api.internal.Parameters;

public class Attributes
extends HashMap<String, String>
implements Serializable {
    public Attributes() {
    }

    public Attributes(Map<String, String> values) {
        super(Parameters.requireNonNull(values, "values"));
    }

    public <T> T get(Key<T> key) {
        Parameters.requireNonNull(key, "key");
        String name = key.getName();
        String value = (String)this.get(name);
        return value != null ? (T)this.fromString(key.getType(), value) : null;
    }

    @Override
    public <T> T put(Key<T> key, T value) {
        Parameters.requireNonNull(key, "key");
        if (!key.getType().equals(value.getClass())) {
            throw new IllegalArgumentException("Value class is not the same as key type");
        }
        T oldValue = this.get(key);
        this.put(key.getName(), value != null ? this.toString(key.getType(), value) : null);
        return oldValue;
    }

    public <T> T remove(Key<T> key) {
        Parameters.requireNonNull(key, "key");
        T oldValue = this.get(key);
        this.remove(key.getName());
        return oldValue;
    }

    public static <T> Key<T> key(String name, Class<T> type) {
        Parameters.requireNonNull(name, "name");
        Parameters.requireNonNull(type, "type");
        if (!type.equals(String.class)) {
            Attributes.getValueOfMethod(type);
        }
        return new Key(name, type);
    }

    private <T> T fromString(Class<T> type, String value) {
        if (type.equals(String.class)) {
            return (T)value;
        }
        Method m = Attributes.getValueOfMethod(type);
        try {
            return (T)m.invoke(null, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid type" + type, e);
        }
    }

    private <T> String toString(Class<T> type, T value) {
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private static Method getValueOfMethod(Class<?> c) {
        try {
            return c.getDeclaredMethod("valueOf", String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported key type. Key type has to either be String or implement 'valueOf(String.class)'");
        }
    }

    public static class Key<T> {
        private final String name;
        private Class<T> type;

        private Key(String name, Class<T> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name) && this.type.equals(this.type);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }
}

