/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.exoplatform.gamification.github.model.Event;
import org.exoplatform.gamification.github.plugin.GithubTriggerPlugin;
import org.exoplatform.gamification.github.utils.Utils;

public class IssueTriggerPlugin
extends GithubTriggerPlugin {
    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String issueState = Utils.extractSubItem(payload, "action");
        Object objectId = Utils.extractSubItem(payload, "issue", "html_url");
        String userId = Utils.extractSubItem(payload, "sender", "login");
        if (Objects.equals(issueState, "opened")) {
            return Collections.singletonList(new Event("createIssue", userId, userId, (String)objectId, "githubIssue"));
        }
        if (Objects.equals(issueState, "closed")) {
            if (Objects.equals(Utils.extractSubItem(payload, "issue", "state_reason"), "not_planned")) {
                return Collections.singletonList(new Event("closeIssue", userId, userId, (String)objectId, "githubIssue"));
            }
            return Collections.emptyList();
        }
        if (Objects.equals(issueState, "labeled")) {
            objectId = (String)objectId + "?label=" + Utils.extractSubItem(payload, "label", "name");
            return Collections.singletonList(new Event("addIssueLabel", userId, userId, (String)objectId, "githubIssue"));
        }
        if (Objects.equals(issueState, "unlabeled")) {
            objectId = (String)objectId + "?label=" + Utils.extractSubItem(payload, "label", "name");
            return Collections.singletonList(new Event("deleteIssueLabel", userId, userId, (String)objectId, "githubIssue"));
        }
        return Collections.emptyList();
    }
}

