/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecms.legacy.search.SearchServiceConnector;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.ecms.legacy.search.data.SearchResult;
import org.exoplatform.news.connector.NewsSearchResult;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.queryBuilder.NewsQueryBuilder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NewsSearchConnector
extends SearchServiceConnector {
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    private static final Log LOG = ExoLogger.getLogger((String)NewsSearchConnector.class.getName());

    public NewsSearchConnector(InitParams initParams, SessionProviderService sessionProviderService, RepositoryService repositoryService) throws Exception {
        super(initParams);
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        NewsFilter filter = new NewsFilter();
        filter.setSearchText(query);
        List<SearchResult> ret = new ArrayList<SearchResult>();
        try {
            ret = this.search(filter, offset, limit, sort, order);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error while searching News", (Throwable)e);
        }
        return ret;
    }

    public List<SearchResult> search(NewsFilter filter, int offset, int limit, String sort, String order) throws RepositoryException {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        ArrayList<SearchResult> res = new ArrayList<SearchResult>();
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        try {
            StringBuilder sqlQuery = queryBuilder.buildQuery(filter);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            ((QueryImpl)query).setOffset((long)filter.getOffset());
            ((QueryImpl)query).setLimit((long)filter.getLimit());
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            RowIterator rowIterator = result.getRows();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                Row row = rowIterator.nextRow();
                Object nodeIllustrationURL = "";
                if (node.hasNode("illustration")) {
                    nodeIllustrationURL = "/portal/rest/v1/news/" + node.getUUID() + "/illustration";
                }
                NewsSearchResult searchResult = new NewsSearchResult("", node.getName(), "", "", (String)nodeIllustrationURL, node.hasProperty("exo:dateCreated") ? node.getProperty("exo:dateCreated").getDate().getTimeInMillis() : 0L, row.getValue("jcr:score") != null ? row.getValue("jcr:score").getLong() : 0L, node);
                res.add(searchResult);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while searching News", (Throwable)e);
        }
        return res;
    }
}

