/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.exoplatform.analytics.listener.social.BaseAttachmentAnalyticsListener;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class ActivityAttachmentAnalyticsListener
extends BaseAttachmentAnalyticsListener {
    private ActivityManager activityManager;

    public ActivityAttachmentAnalyticsListener(AttachmentService attachmentService, SpaceService spaceService, ActivityManager activityManager, InitParams initParam) {
        super(attachmentService, spaceService, initParam);
        this.activityManager = activityManager;
    }

    @Override
    protected void extendStatisticData(StatisticData statisticData, ObjectAttachmentId objectAttachment) {
        ExoSocialActivity activity = this.activityManager.getActivity(objectAttachment.getObjectId());
        if (activity != null) {
            AnalyticsUtils.addActivityStatisticsData((StatisticData)statisticData, (ExoSocialActivity)activity);
        }
    }

    @Override
    protected String getModule(ObjectAttachmentId objectAttachment) {
        return "social";
    }

    @Override
    protected String getSubModule(ObjectAttachmentId objectAttachment) {
        return "activity";
    }
}

