/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.FieldType;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;

public class ConstrainedFieldBuilder {
    private static final Log log = LoggerFactory.make();

    private ConstrainedFieldBuilder() {
    }

    public static Set<ConstrainedField> buildConstrainedFields(List<FieldType> fields, Class<?> beanClass, String defaultPackage, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<ConstrainedField> constrainedFields = CollectionHelper.newHashSet();
        ArrayList<String> alreadyProcessedFieldNames = CollectionHelper.newArrayList();
        for (FieldType fieldType : fields) {
            Field field = ConstrainedFieldBuilder.findField(beanClass, fieldType.getName(), alreadyProcessedFieldNames);
            ConstraintLocation constraintLocation = ConstraintLocation.forProperty(field);
            HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
            for (ConstraintType constraint : fieldType.getConstraint()) {
                MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.FIELD, defaultPackage, constraintHelper, null);
                metaConstraints.add(metaConstraint);
            }
            Map<Class<?>, Class<?>> groupConversions = GroupConversionBuilder.buildGroupConversionMap(fieldType.getConvertGroup(), defaultPackage);
            ConstrainedField constrainedField = new ConstrainedField(ConfigurationSource.XML, constraintLocation, metaConstraints, groupConversions, fieldType.getValid() != null, false);
            constrainedFields.add(constrainedField);
            if (fieldType.getIgnoreAnnotations() == null) continue;
            annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(field, fieldType.getIgnoreAnnotations());
        }
        return constrainedFields;
    }

    private static Field findField(Class<?> beanClass, String fieldName, List<String> alreadyProcessedFieldNames) {
        if (alreadyProcessedFieldNames.contains(fieldName)) {
            throw log.getIsDefinedTwiceInMappingXmlForBeanException(fieldName, beanClass.getName());
        }
        alreadyProcessedFieldNames.add(fieldName);
        Field field = ReflectionHelper.getDeclaredField(beanClass, fieldName);
        if (field == null) {
            throw log.getBeanDoesNotContainTheFieldException(beanClass.getName(), fieldName);
        }
        return field;
    }
}

