/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONObject;

public class ElasticContentRequestBuilder {
    private static final Log LOG = ExoLogger.getExoLogger(ElasticContentRequestBuilder.class);
    private static final long DEFAULT_MAX_REGEX_LENGTH = 65536L;
    private static final String DEFAULT_INDEX_SETTINGS_FILE_PATH = "jar:/es-default-index-settings.json";
    private static final String INDEX_SETTINGS_FILE_PATH_PARAM = "index.settings.path";
    private ConfigurationManager configurationManager;
    private String defaultSettingsPath;
    private String defaultSettings;

    public ElasticContentRequestBuilder(ConfigurationManager configurationManager, InitParams initParams) {
        this.configurationManager = configurationManager;
        if (initParams != null && initParams.getValueParam(INDEX_SETTINGS_FILE_PATH_PARAM) != null) {
            this.defaultSettingsPath = initParams.getValueParam(INDEX_SETTINGS_FILE_PATH_PARAM).getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.defaultSettingsPath)) {
            this.defaultSettingsPath = DEFAULT_INDEX_SETTINGS_FILE_PATH;
        }
    }

    public ElasticContentRequestBuilder() {
        this((ConfigurationManager)ExoContainerContext.getService(ConfigurationManager.class), null);
    }

    public String getCreateIndexRequestContent(ElasticIndexingServiceConnector connector) {
        String settings = this.getDefaultSettings().replace("shard.number", String.valueOf(connector.getShards())).replace("replica.number", String.valueOf(connector.getReplicas())).replace("max_regex.length", String.valueOf(65536L));
        LOG.debug("Create index request to ES: \n {}", new Object[]{settings});
        return settings;
    }

    public String getDeleteAllDocumentsRequestContent() {
        JSONObject deleteAllRequest = new JSONObject();
        JSONObject deleteQueryRequest = new JSONObject();
        deleteQueryRequest.put((Object)"match_all", (Object)new JSONObject());
        deleteAllRequest.put((Object)"query", (Object)deleteQueryRequest);
        String request = deleteAllRequest.toJSONString();
        LOG.debug("Delete All request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getDeleteDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject cudHeaderRequest = this.createCUDHeaderRequestContent(connector, id);
        String request = null;
        if (cudHeaderRequest != null) {
            JSONObject deleteRequest = new JSONObject();
            deleteRequest.put((Object)"delete", (Object)cudHeaderRequest);
            request = deleteRequest.toJSONString() + "\n";
        }
        LOG.debug("Delete request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getCreateDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject ElasticInformation = this.createCUDHeaderRequestContent(connector, id);
        Document document = connector.create(id);
        if (document == null) {
            LOG.debug("Can't find document with id '{}' using connector '{}'. Ignore it.", new Object[]{id, connector.getIndexAlias()});
            return null;
        }
        JSONObject createRequest = new JSONObject();
        createRequest.put((Object)"create", (Object)ElasticInformation);
        String request = createRequest.toJSONString() + "\n" + document.toJSON() + "\n";
        LOG.debug("Create request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getCreatePipelineDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        Document document = connector.update(id);
        String request = null;
        if (document != null) {
            request = document.toJSON();
        }
        LOG.debug("Create Pipeline document request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getUpdateDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject ElasticInformation = this.createCUDHeaderRequestContent(connector, id);
        Document document = connector.update(id);
        String request = null;
        if (document != null) {
            JSONObject updateRequest = new JSONObject();
            updateRequest.put((Object)"index", (Object)ElasticInformation);
            request = updateRequest.toJSONString() + "\n" + document.toJSON() + "\n";
        }
        LOG.debug("Update request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getDefaultSettings() {
        if (this.defaultSettings == null) {
            try {
                this.defaultSettings = this.getFileContent(this.defaultSettingsPath);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to retrieve default ES index settings from path: " + this.defaultSettingsPath, e);
            }
        }
        return this.defaultSettings;
    }

    private JSONObject createCUDHeaderRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject cudHeader = new JSONObject();
        cudHeader.put((Object)"_index", (Object)connector.getIndexAlias());
        cudHeader.put((Object)"_id", (Object)id);
        return cudHeader;
    }

    private String getFileContent(String filePath) throws Exception {
        InputStream mappingFileIS = this.configurationManager.getInputStream(filePath);
        return IOUtil.getStreamContentAsString((InputStream)mappingFileIS);
    }
}

