/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage.cached;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.dao.EventRecurrenceDAO;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CachedAgendaEventStorage
extends AgendaEventStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedAgendaEventStorage.class);
    public static final String EVENT_CACHE_NAME = "agenda.event";
    private FutureExoCache<Long, Event, Object> eventFutureCache = null;
    private ExoCache<Long, Event> eventCache = null;

    public CachedAgendaEventStorage(CacheService cacheService, CalendarDAO calendarDAO, EventDAO eventDAO, EventRecurrenceDAO eventRecurrenceDAO) {
        super(calendarDAO, eventDAO, eventRecurrenceDAO);
        this.eventCache = cacheService.getCacheInstance(EVENT_CACHE_NAME);
        this.eventFutureCache = new FutureExoCache((Loader)new Loader<Long, Event, Object>(){

            public Event retrieve(Object context, Long eventId) throws Exception {
                return CachedAgendaEventStorage.super.getEventById(eventId);
            }
        }, this.eventCache);
    }

    @Override
    public Event getEventById(long eventId) {
        Event event = (Event)this.eventFutureCache.get(null, (Object)eventId);
        return event == null ? null : event.clone();
    }

    @Override
    public Event updateEvent(Event event) {
        Event updatedEvent = super.updateEvent(event);
        this.eventFutureCache.remove((Serializable)Long.valueOf(event.getId()));
        return updatedEvent;
    }

    @Override
    public void deleteEventById(long eventId) {
        super.deleteEventById(eventId);
        this.eventFutureCache.remove((Serializable)Long.valueOf(eventId));
    }

    @Override
    public void deleteCalendarEvents(final long calendarId) {
        super.deleteCalendarEvents(calendarId);
        try {
            this.eventCache.select((CachedObjectSelector)new CachedObjectSelector<Long, Event>(){

                public void onSelect(ExoCache<? extends Long, ? extends Event> cache, Long eventId, ObjectCacheInfo<? extends Event> ocinfo) throws Exception {
                    cache.remove((Serializable)eventId);
                }

                public boolean select(Long key, ObjectCacheInfo<? extends Event> ocinfo) {
                    return ((Event)ocinfo.get()).getCalendarId() == calendarId;
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when clearing event cache", (Throwable)e);
        }
    }

    @Override
    public List<Long> deleteExceptionalOccurences(long parentRecurrentEventId) {
        List<Long> exceptionalEventIds = super.deleteExceptionalOccurences(parentRecurrentEventId);
        if (exceptionalEventIds != null) {
            for (Long exceptionalEventId : exceptionalEventIds) {
                this.eventFutureCache.remove((Serializable)exceptionalEventId);
            }
        }
        return exceptionalEventIds;
    }

    public void clearCache() {
        this.eventFutureCache.clear();
    }
}

