/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.dao;

import io.meeds.gamification.twitter.entity.TwitterAccountEntity;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class TwitterAccountDAO
extends GenericDAOJPAImpl<TwitterAccountEntity, Long> {
    public static final String REMOTE_ID = "remoteId";

    public TwitterAccountEntity getAccountByRemoteId(long remoteId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("TwitterAccounts.getTwitterAccountByRemoteId", TwitterAccountEntity.class);
        query.setParameter(REMOTE_ID, (Object)remoteId);
        try {
            return (TwitterAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Long> getAccountsIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("TwitterAccounts.getAccountsIds", Long.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }
}

