/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.rest.builder;

import io.meeds.gamification.twitter.model.RemoteTwitterAccount;
import io.meeds.gamification.twitter.model.TokenStatus;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.rest.model.TwitterAccountRestEntity;
import io.meeds.gamification.twitter.service.TwitterAccountService;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import java.util.Collection;
import java.util.List;

public class TwitterAccountBuilder {
    private TwitterAccountBuilder() {
    }

    public static TwitterAccountRestEntity toRestEntity(String twitterBearerToken, TokenStatus tokenStatus, TwitterConsumerService twitterConsumerService, TwitterAccount twitterAccount) {
        if (twitterAccount == null) {
            return null;
        }
        RemoteTwitterAccount remoteTwitterAccount = null;
        if (Boolean.TRUE.equals(tokenStatus != null && tokenStatus.getIsValid() != null && tokenStatus.getIsValid() != false) && tokenStatus.getRemaining() > 0L) {
            remoteTwitterAccount = twitterConsumerService.retrieveTwitterAccount(twitterAccount.getRemoteId(), twitterBearerToken);
        }
        return new TwitterAccountRestEntity(twitterAccount.getId(), twitterAccount.getRemoteId(), twitterAccount.getIdentifier(), remoteTwitterAccount != null ? remoteTwitterAccount.getName() : twitterAccount.getName(), twitterAccount.getWatchedDate(), twitterAccount.getWatchedBy(), twitterAccount.getUpdatedDate(), twitterAccount.getRefreshDate(), remoteTwitterAccount != null ? remoteTwitterAccount.getDescription() : null, remoteTwitterAccount != null ? remoteTwitterAccount.getAvatarUrl() : null);
    }

    public static List<TwitterAccountRestEntity> toRestEntities(TwitterAccountService twitterAccountService, TwitterConsumerService twitterConsumerService, Collection<TwitterAccount> twitterAccounts) {
        String twitterBearerToken = twitterAccountService.getTwitterBearerToken();
        TokenStatus tokenStatus = twitterConsumerService.checkTwitterTokenStatus(twitterBearerToken);
        return twitterAccounts.stream().map(twitterAccount -> TwitterAccountBuilder.toRestEntity(twitterBearerToken, tokenStatus, twitterConsumerService, twitterAccount)).toList();
    }
}

