/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.scheduled;

import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import io.meeds.gamification.twitter.scheduled.TwitterAccountRemoteUpdate$AjcClosure1;
import io.meeds.gamification.twitter.service.TwitterAccountService;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import io.meeds.gamification.twitter.service.TwitterTriggerService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class TwitterAccountRemoteUpdate
implements Job {
    private static final Log LOG;
    private final TwitterConsumerService twitterConsumerService;
    private final TwitterAccountService twitterAccountService;
    private final TwitterTriggerService twitterTriggerService = (TwitterTriggerService)ExoContainerContext.getService(TwitterTriggerService.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TwitterAccountRemoteUpdate() {
        this.twitterConsumerService = (TwitterConsumerService)ExoContainerContext.getService(TwitterConsumerService.class);
        this.twitterAccountService = (TwitterAccountService)ExoContainerContext.getService(TwitterAccountService.class);
    }

    @ExoTransactional
    public void execute(JobExecutionContext context) {
        JobExecutionContext jobExecutionContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jobExecutionContext);
        Object[] objectArray = new Object[]{this, jobExecutionContext, joinPoint};
        TwitterAccountRemoteUpdate$AjcClosure1 twitterAccountRemoteUpdate$AjcClosure1 = new TwitterAccountRemoteUpdate$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(twitterAccountRemoteUpdate$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void processTwitterAccount(TwitterAccount twitterAccount, String bearerToken) {
        try {
            List<TwitterTrigger> mentionTriggers = this.twitterConsumerService.getMentionEvents(twitterAccount.getRemoteId(), twitterAccount.getLastMentionTweetId(), bearerToken);
            if (CollectionUtils.isNotEmpty(mentionTriggers)) {
                mentionTriggers.forEach(this.twitterTriggerService::handleTriggerAsync);
                this.twitterAccountService.updateAccountLastMentionTweetId(twitterAccount.getId(), mentionTriggers.get(0).getTweetId());
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Error while updating twitter account {}", new Object[]{twitterAccount.getId(), e});
        }
    }

    static {
        TwitterAccountRemoteUpdate.ajc$preClinit();
        LOG = ExoLogger.getLogger(TwitterAccountRemoteUpdate.class);
    }

    static /* synthetic */ void execute_aroundBody0(TwitterAccountRemoteUpdate ajc$this, JobExecutionContext context, JoinPoint joinPoint) {
        String bearerToken = ajc$this.twitterAccountService.getTwitterBearerToken();
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            return;
        }
        List<TwitterAccount> twitterAccounts = ajc$this.twitterAccountService.getTwitterAccounts(0, -1);
        if (CollectionUtils.isNotEmpty(twitterAccounts)) {
            twitterAccounts.forEach(twitterAccount -> this.processTwitterAccount((TwitterAccount)twitterAccount, bearerToken));
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TwitterAccountRemoteUpdate.java", TwitterAccountRemoteUpdate.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.meeds.gamification.twitter.scheduled.TwitterAccountRemoteUpdate", "org.quartz.JobExecutionContext", "context", "", "void"), 62);
    }
}

