/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoveNewsRootNodeUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(RemoveNewsRootNodeUpgradePlugin.class);
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    public static final String APPLICATION_DATA_PATH = "/Application Data";
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String PUBLISHED_NEWS_NODES_FOLDER = "Pinned";

    public RemoveNewsRootNodeUpgradePlugin(InitParams initParams, RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String s, String s1) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start removing news root node");
        try (SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);){
            Node newsRootNode;
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            Node applicationDataNode = (Node)session.getItem(APPLICATION_DATA_PATH);
            if (applicationDataNode.hasNode(NEWS_NODES_FOLDER) && (newsRootNode = applicationDataNode.getNode(NEWS_NODES_FOLDER)).hasNode(PUBLISHED_NEWS_NODES_FOLDER)) {
                Node newsPinnedNode = newsRootNode.getNode(PUBLISHED_NEWS_NODES_FOLDER);
                newsPinnedNode.remove();
                newsRootNode.save();
                applicationDataNode.save();
            }
            LOG.info("End removing news root node", new Object[]{System.currentTimeMillis() - startupTime});
        }
    }
}

