/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.upgrade;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class MoveNodesUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)MoveNodesUpgradePlugin.class.getName());
    private static final String ORIGIN_PATH = "origin-folder-path";
    private static final String DESTINATION_PATH = "destination-folder-path";
    private static final String FOLDERS_TO_REMOVE = "folders-to-remove";
    private static final int SPACES_PAGE_SIZE = 2;
    private final SpaceService spaceService;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private String originPath;
    private String destinationPath;
    private List<String> foldersToRemove = new ArrayList<String>();

    public MoveNodesUpgradePlugin(InitParams initParams, SpaceService spaceService, RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        super(initParams);
        if (initParams.getValueParam(ORIGIN_PATH) != null && StringUtils.isNotBlank((CharSequence)initParams.getValueParam(ORIGIN_PATH).getValue())) {
            this.originPath = initParams.getValueParam(ORIGIN_PATH).getValue();
        }
        if (initParams.getValueParam(ORIGIN_PATH) != null && StringUtils.isNotBlank((CharSequence)initParams.getValueParam(ORIGIN_PATH).getValue())) {
            this.destinationPath = initParams.getValueParam(DESTINATION_PATH).getValue();
        }
        if (initParams.getValuesParam(FOLDERS_TO_REMOVE) != null && !initParams.getValuesParam(FOLDERS_TO_REMOVE).getValues().isEmpty()) {
            this.foldersToRemove = initParams.getValuesParam(FOLDERS_TO_REMOVE).getValues();
        }
        this.spaceService = spaceService;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (StringUtils.isBlank((CharSequence)this.originPath) || StringUtils.isBlank((CharSequence)this.destinationPath)) {
            log.warn("Invalid parameter was provided for {}, this upgrade plugin will be ignored", new Object[]{StringUtils.isBlank((CharSequence)this.originPath) ? "'Origin path'" : "'Destination path'"});
            return;
        }
        long startupTime = System.currentTimeMillis();
        int movedFoldersCount = 0;
        log.info("Start upgrade : Moving of folder from {} to {}", new Object[]{this.originPath, this.destinationPath});
        SessionProvider sessionProvider = null;
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            ListAccess spaces = this.spaceService.getAllSpacesWithListAccess();
            for (int index = 0; index <= spaces.getSize(); index += 2) {
                Space[] spaceArray;
                for (Space space : spaceArray = (Space[])spaces.load(index, 2)) {
                    String originFolderPath = "/Groups" + space.getGroupId() + this.originPath;
                    String destinationFolderPath = "/Groups" + space.getGroupId() + this.destinationPath;
                    try {
                        Item originFolderNode = session.getItem(originFolderPath);
                        if (originFolderNode != null) {
                            session.move(originFolderPath, destinationFolderPath);
                            ++movedFoldersCount;
                        }
                    }
                    catch (RepositoryException e) {
                        if (log.isDebugEnabled()) {
                            log.warn("Folder {} to move was not found, ignoring it", new Object[]{originFolderPath, e});
                        }
                        log.warn("Folder {} to move was not found, ignoring it", new Object[]{originFolderPath});
                    }
                    if (this.foldersToRemove.isEmpty()) continue;
                    for (String string : this.foldersToRemove) {
                        String string2 = "/Groups" + space.getGroupId() + string;
                        try {
                            Item folderToRemoveNode = session.getItem(string2);
                            if (folderToRemoveNode == null) continue;
                            folderToRemoveNode.remove();
                        }
                        catch (RepositoryException re) {
                            if (log.isDebugEnabled()) {
                                log.warn("Folder {} to delete was not found, ignoring it", new Object[]{string2, re});
                                continue;
                            }
                            log.warn("Folder {} to delete was not found, ignoring it", new Object[]{string2});
                        }
                    }
                }
                session.save();
            }
            log.info("End Moving of '{}' folders. It took {} ms", new Object[]{movedFoldersCount, System.currentTimeMillis() - startupTime});
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"An unexpected error occurs when moving folders:", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
            RequestLifeCycle.end();
        }
    }
}

