/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.Resource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.MultipartByterangesEntity;
import org.exoplatform.services.jcr.webdav.util.RangedInputStream;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.provider.XSLTStreamingOutput;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;

public class GetCommand {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.GetCommand");
    private Map<String, String> xsltParams;

    public GetCommand() {
    }

    public GetCommand(Map<String, String> xsltParams) {
        this.xsltParams = xsltParams;
    }

    public Response get(Session session, String path, String version, String baseURI, List<Range> ranges, String ifModifiedSince, String ifNoneMatch, Map<MediaType, String> cacheControls) {
        if (version == null && path.indexOf("?version=") > 0) {
            version = path.substring(path.indexOf("?version=") + "?version=".length());
            path = path.substring(0, path.indexOf("?version="));
        }
        InputStream istream = null;
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            if (ResourceUtil.isFile(node)) {
                HierarchicalProperty lastModifiedProperty;
                GenericResource resource;
                if (version != null) {
                    String[] versionedFile = new VersionedFileResource(uri, node, nsContext);
                    resource = versionedFile.getVersionHistory().getVersion(version);
                    lastModifiedProperty = resource.getProperty(FileResource.GETLASTMODIFIED);
                } else {
                    resource = new FileResource(uri, node, nsContext);
                    lastModifiedProperty = resource.getProperty(FileResource.GETLASTMODIFIED);
                }
                String resourceEntityTag = ResourceUtil.generateEntityTag(node, lastModifiedProperty.getValue());
                if (ifNoneMatch != null) {
                    if ("*".equals(ifNoneMatch)) {
                        return Response.notModified().entity((Object)"Not Modified").build();
                    }
                    for (String eTag : ifNoneMatch.split(",")) {
                        if (!resourceEntityTag.equals(eTag)) continue;
                        return Response.notModified().entity((Object)"Not Modified").build();
                    }
                } else if (ifModifiedSince != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    Date lastModifiedDate = dateFormat.parse(lastModifiedProperty.getValue());
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
                    if (ifModifiedSinceDate.getTime() >= lastModifiedDate.getTime()) {
                        return Response.notModified().entity((Object)"Not Modified").build();
                    }
                }
                try {
                    if (resource instanceof VersionResource) {
                        ((VersionResource)resource).contentNode().getProperty("jcr:data");
                    } else {
                        resource.getProperty(new QName("jcr", "data", "jcr"));
                    }
                }
                catch (RepositoryException exc) {
                    LOG.error((Object)exc.getMessage(), (Throwable)exc);
                    String message = "The requested resource (" + path + ") is no longer available. Please contact your administrator.";
                    return Response.status((int)404).entity((Object)message).build();
                }
                HierarchicalProperty contentLengthProperty = resource.getProperty(FileResource.GETCONTENTLENGTH);
                long contentLength = new Long(contentLengthProperty.getValue());
                if (contentLength == 0L) {
                    istream = this.openStream(resource, version != null);
                    return Response.ok().header("Accept-Ranges", (Object)"bytes").entity((Object)istream).build();
                }
                HierarchicalProperty mimeTypeProperty = resource.getProperty(FileResource.GETCONTENTTYPE);
                String contentType = mimeTypeProperty.getValue();
                if (ranges.size() == 0) {
                    istream = this.openStream(resource, version != null);
                    return Response.ok().header("Content-Length", (Object)Long.toString(contentLength)).header("Accept-Ranges", (Object)"bytes").header("Last-Modified", (Object)lastModifiedProperty.getValue()).header("ETag", (Object)resourceEntityTag).header("Cache-Control", (Object)this.generateCacheControl(cacheControls, contentType)).entity((Object)istream).type(contentType).build();
                }
                if (ranges.size() == 1) {
                    Range range = ranges.get(0);
                    if (!this.validateRange(range, contentLength)) {
                        return Response.status((int)416).header("Content-Range", (Object)("bytes */" + contentLength)).build();
                    }
                    long start = range.getStart();
                    long end = range.getEnd();
                    long returnedContentLength = end - start + 1L;
                    istream = this.openStream(resource, version != null);
                    RangedInputStream rangedInputStream = new RangedInputStream(istream, start, end);
                    return Response.status((int)206).header("Content-Length", (Object)Long.toString(returnedContentLength)).header("Accept-Ranges", (Object)"bytes").header("Last-Modified", (Object)lastModifiedProperty.getValue()).header("ETag", (Object)resourceEntityTag).header("Content-Range", (Object)("bytes " + start + "-" + end + "/" + contentLength)).entity((Object)rangedInputStream).type(contentType).build();
                }
                for (int i = 0; i < ranges.size(); ++i) {
                    Range range = ranges.get(i);
                    if (!this.validateRange(range, contentLength)) {
                        return Response.status((int)416).header("Content-Range", (Object)("bytes */" + contentLength)).build();
                    }
                    ranges.set(i, range);
                }
                MultipartByterangesEntity mByterangesEntity = new MultipartByterangesEntity(resource, ranges, contentType, contentLength);
                return Response.status((int)206).header("Accept-Ranges", (Object)"bytes").header("Last-Modified", (Object)lastModifiedProperty.getValue()).entity((Object)mByterangesEntity).header("ETag", (Object)resourceEntityTag).type("multipart/byteranges; boundary=1234567890").build();
            }
            CollectionResource resource = new CollectionResource(uri, node, nsContext);
            istream = resource.getContentAsStream(baseURI);
            XSLTStreamingOutput entity = new XSLTStreamingOutput("get.method.template", (Source)new StreamSource(istream), this.xsltParams);
            return Response.ok((Object)entity, (String)"text/html").build();
        }
        catch (PathNotFoundException exc) {
            this.closeStream(istream);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            this.closeStream(istream);
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            this.closeStream(istream);
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    private boolean validateRange(Range range, long contentLength) {
        long start = range.getStart();
        long end = range.getEnd();
        if (start < 0L && end == -1L) {
            if (-1L * start >= contentLength) {
                start = 0L;
                end = contentLength - 1L;
            } else {
                start = contentLength + start;
                end = contentLength - 1L;
            }
        }
        if (start >= 0L && end == -1L) {
            end = contentLength - 1L;
        }
        if (end >= contentLength) {
            end = contentLength - 1L;
        }
        if (start >= 0L && end >= 0L && start <= end) {
            range.setStart(start);
            range.setEnd(end);
            return true;
        }
        return false;
    }

    private String generateCacheControl(Map<MediaType, String> cacheControlMap, String contentType) {
        ArrayList<MediaType> mediaTypesList = new ArrayList<MediaType>(cacheControlMap.keySet());
        Collections.sort(mediaTypesList, MediaTypeHelper.MEDIA_TYPE_COMPARATOR);
        String cacheControlValue = "no-cache";
        if (contentType == null || contentType.equals("")) {
            return cacheControlValue;
        }
        for (MediaType mediaType : mediaTypesList) {
            if (contentType.equals("*/*")) {
                cacheControlValue = cacheControlMap.get(MediaType.WILDCARD_TYPE);
                break;
            }
            if (!mediaType.isCompatible(new MediaType(contentType.split("/")[0], contentType.split("/")[1]))) continue;
            cacheControlValue = cacheControlMap.get(mediaType);
            break;
        }
        return cacheControlValue;
    }

    private InputStream openStream(Resource resource, boolean isVersionableResource) throws RepositoryException {
        return isVersionableResource ? ((VersionResource)resource).getContentAsStream() : ((FileResource)resource).getContentAsStream();
    }

    private void closeStream(InputStream istream) {
        if (istream != null) {
            try {
                istream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Can't close the stream", (Throwable)e);
            }
        }
    }
}

