/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.commons.util.concurrent.jdk8backported.Unsafe;

class StrippedConcurrentLinkedDeque<E> {
    volatile transient DequeNode<E> head;
    volatile transient DequeNode<E> tail;
    static final DequeNode<Object> PREV_TERMINATOR = new DequeNode();
    static final DequeNode<Object> NEXT_TERMINATOR;
    final DequeNode<E> DEFAULT = new DequeNode();
    private static final int HOPS = 2;
    private static final sun.misc.Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    DequeNode<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    DequeNode<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    DequeNode<E> defaultNode() {
        return this.DEFAULT;
    }

    public StrippedConcurrentLinkedDeque() {
        this.tail = this.defaultNode();
        this.head = this.tail;
    }

    public E pollFirst() {
        DequeNode<Object> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && p.casItem(item, null)) {
                this.unlink(p);
                return item;
            }
            p = this.succ(p);
        }
        return null;
    }

    public boolean pollFirstNode(Object[] nodeValue) {
        DequeNode<Object> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && p.casItem(item, null)) {
                this.unlink(p);
                nodeValue[0] = p;
                nodeValue[1] = item;
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    DequeNode<E> first() {
        DequeNode<E> h;
        DequeNode<E> p;
        block0: do {
            DequeNode q;
            p = h = this.head;
            while ((q = p.prev) != null) {
                p = q;
                q = p.prev;
                if (q == null) continue block0;
                p = h != (h = this.head) ? h : q;
            }
        } while (p != h && !this.casHead(h, p));
        return p;
    }

    final DequeNode<E> succ(DequeNode<E> p) {
        DequeNode q = p.next;
        return p == q ? this.first() : q;
    }

    void linkLast(DequeNode<E> newNode) {
        DequeNode p;
        DequeNode t;
        block0: while (true) {
            p = t = this.tail;
            while (true) {
                DequeNode q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block0;
                newNode.lazySetPrev(p);
                if (p.casNext(null, newNode)) break block0;
            }
            break;
        }
        if (p != t) {
            this.casTail(t, newNode);
        }
    }

    void unlink(DequeNode<E> x) {
        boolean isLast;
        DequeNode activeSucc;
        DequeNode q;
        boolean isFirst;
        DequeNode activePred;
        DequeNode prev = x.prev;
        DequeNode next = x.next;
        if (prev == null) {
            this.unlinkFirst(x, next);
            return;
        }
        if (next == null) {
            this.unlinkLast(x, prev);
            return;
        }
        int hops = 1;
        DequeNode p = prev;
        while (true) {
            if (p.item != null) {
                activePred = p;
                isFirst = false;
                break;
            }
            q = p.prev;
            if (q == null) {
                if (p.next == p) {
                    return;
                }
                activePred = p;
                isFirst = true;
                break;
            }
            if (p == q) {
                return;
            }
            p = q;
            ++hops;
        }
        p = next;
        while (true) {
            if (p.item != null) {
                activeSucc = p;
                isLast = false;
                break;
            }
            q = p.next;
            if (q == null) {
                if (p.prev == p) {
                    return;
                }
                activeSucc = p;
                isLast = true;
                break;
            }
            if (p == q) {
                return;
            }
            p = q;
            ++hops;
        }
        if (hops < 2 && isFirst | isLast) {
            return;
        }
        this.skipDeletedSuccessors(activePred);
        this.skipDeletedPredecessors(activeSucc);
        if (isFirst | isLast && activePred.next == activeSucc && activeSucc.prev == activePred && (isFirst ? activePred.prev == null : activePred.item != null) && (isLast ? activeSucc.next == null : activeSucc.item != null)) {
            this.updateHead();
            this.updateTail();
            x.lazySetPrev(isFirst ? this.prevTerminator() : x);
            x.lazySetNext(isLast ? this.nextTerminator() : x);
            return;
        }
    }

    private void unlinkFirst(DequeNode<E> first, DequeNode<E> next) {
        DequeNode<E> o = null;
        DequeNode<E> p = next;
        while (true) {
            DequeNode q;
            if (p.item != null || (q = p.next) == null) {
                if (o != null && p.prev != p && first.casNext(next, p)) {
                    this.skipDeletedPredecessors(p);
                    if (first.prev == null && (p.next == null || p.item != null) && p.prev == first) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetNext(o);
                        o.lazySetPrev(this.prevTerminator());
                    }
                }
                return;
            }
            if (p == q) {
                return;
            }
            o = p;
            p = q;
        }
    }

    private void unlinkLast(DequeNode<E> last, DequeNode<E> prev) {
        DequeNode<E> o = null;
        DequeNode<E> p = prev;
        while (true) {
            DequeNode q;
            if (p.item != null || (q = p.prev) == null) {
                if (o != null && p.next != p && last.casPrev(prev, p)) {
                    this.skipDeletedSuccessors(p);
                    if (last.next == null && (p.prev == null || p.item != null) && p.next == last) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetPrev(o);
                        o.lazySetNext(this.nextTerminator());
                    }
                }
                return;
            }
            if (p == q) {
                return;
            }
            o = p;
            p = q;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateHead() {
        block0: while (true) {
            h = this.head;
            if (h.item != null || (p = h.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.prev) == null) break block4;
                        p = q;
                        q = p.prev;
                        if (q != null) break block5;
                    }
                    if (!this.casHead(h, p)) continue block0;
                    return;
                }
                if (h == this.head) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTail() {
        block0: while (true) {
            t = this.tail;
            if (t.item != null || (p = t.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.next) == null) break block4;
                        p = q;
                        q = p.next;
                        if (q != null) break block5;
                    }
                    if (!this.casTail(t, p)) continue block0;
                    return;
                }
                if (t == this.tail) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    void skipDeletedPredecessors(DequeNode<E> x) {
        block0: do {
            DequeNode prev;
            DequeNode p = prev = x.prev;
            while (p.item == null) {
                DequeNode q = p.prev;
                if (q == null) {
                    if (p.next != p) break;
                    continue block0;
                }
                if (p == q) continue block0;
                p = q;
            }
            if (prev != p && !x.casPrev(prev, p)) continue;
            return;
        } while (x.item != null || x.next == null);
    }

    void skipDeletedSuccessors(DequeNode<E> x) {
        block0: do {
            DequeNode next;
            DequeNode p = next = x.next;
            while (p.item == null) {
                DequeNode q = p.next;
                if (q == null) {
                    if (p.prev != p) break;
                    continue block0;
                }
                if (p == q) continue block0;
                p = q;
            }
            if (next != p && !x.casNext(next, p)) continue;
            return;
        } while (x.item != null || x.prev == null);
    }

    final DequeNode<E> pred(DequeNode<E> p) {
        DequeNode q = p.prev;
        return p == q ? this.last() : q;
    }

    public DequeNode<E> peekFirstNode() {
        DequeNode<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return p;
            }
            p = this.succ(p);
        }
        return null;
    }

    public DequeNode<E> peekLastNode() {
        DequeNode<E> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return p;
            }
            p = this.pred(p);
        }
        return null;
    }

    DequeNode<E> last() {
        DequeNode<E> t;
        DequeNode<E> p;
        block0: do {
            DequeNode q;
            p = t = this.tail;
            while ((q = p.next) != null) {
                p = q;
                q = p.next;
                if (q == null) continue block0;
                p = t != (t = this.tail) ? t : q;
            }
        } while (p != t && !this.casTail(t, p));
        return p;
    }

    private boolean casHead(DequeNode<E> cmp, DequeNode<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private boolean casTail(DequeNode<E> cmp, DequeNode<E> val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    static {
        StrippedConcurrentLinkedDeque.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new DequeNode();
        StrippedConcurrentLinkedDeque.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<StrippedConcurrentLinkedDeque> k = StrippedConcurrentLinkedDeque.class;
            headOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("tail"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    class DescendingItr
    extends AbstractItr {
        DescendingItr() {
        }

        @Override
        DequeNode<E> startNode() {
            return StrippedConcurrentLinkedDeque.this.last();
        }

        @Override
        DequeNode<E> nextNode(DequeNode<E> p) {
            return StrippedConcurrentLinkedDeque.this.pred(p);
        }
    }

    class Itr
    extends AbstractItr {
        Itr() {
        }

        @Override
        DequeNode<E> startNode() {
            return StrippedConcurrentLinkedDeque.this.first();
        }

        @Override
        DequeNode<E> nextNode(DequeNode<E> p) {
            return StrippedConcurrentLinkedDeque.this.succ(p);
        }
    }

    abstract class AbstractItr
    implements Iterator<DequeNode<E>> {
        private DequeNode<E> nextNode;
        private DequeNode<E> lastRet;

        abstract DequeNode<E> startNode();

        abstract DequeNode<E> nextNode(DequeNode<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            DequeNode p;
            this.lastRet = this.nextNode;
            DequeNode dequeNode = p = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    break;
                }
                Object item = p.item;
                if (item != null) {
                    this.nextNode = p;
                    break;
                }
                p = this.nextNode(p);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public DequeNode<E> next() {
            DequeNode node = this.nextNode;
            if (node == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return node;
        }

        @Override
        public void remove() {
            DequeNode l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            StrippedConcurrentLinkedDeque.this.unlink(l);
            this.lastRet = null;
        }
    }

    static class DequeNode<E> {
        volatile DequeNode<E> prev;
        volatile E item;
        volatile DequeNode<E> next;
        private static final sun.misc.Unsafe UNSAFE;
        private static final long prevOffset;
        private static final long itemOffset;
        private static final long nextOffset;

        DequeNode() {
        }

        public String toString() {
            return "DequeNode [item=" + this.item + "]";
        }

        DequeNode(E item) {
            UNSAFE.putObject(this, itemOffset, item);
        }

        void resetLazily(E item) {
            UNSAFE.putObject(this, itemOffset, item);
            this.lazySetNext(null);
            this.lazySetPrev(null);
        }

        boolean casItem(E cmp, E val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        void lazySetNext(DequeNode<E> val) {
            UNSAFE.putOrderedObject(this, nextOffset, val);
        }

        boolean casNext(DequeNode<E> cmp, DequeNode<E> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        void lazySetPrev(DequeNode<E> val) {
            UNSAFE.putOrderedObject(this, prevOffset, val);
        }

        boolean casPrev(DequeNode<E> cmp, DequeNode<E> val) {
            return UNSAFE.compareAndSwapObject(this, prevOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<DequeNode> k = DequeNode.class;
                prevOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("prev"));
                itemOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("next"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

