/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;

public class NameQuery
extends Query {
    private static final long serialVersionUID = 6411494650704435343L;
    private final InternalQName nodeName;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;

    public NameQuery(InternalQName nodeName, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this.nodeName = nodeName;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    public InternalQName getName() {
        return this.nodeName;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.version.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            BooleanQuery name = new BooleanQuery();
            name.add((Query)new JcrTermQuery(new Term(FieldNames.NAMESPACE_URI, this.nodeName.getNamespace())), BooleanClause.Occur.MUST);
            name.add((Query)new JcrTermQuery(new Term(FieldNames.LOCAL_NAME, this.nodeName.getName())), BooleanClause.Occur.MUST);
            return name;
        }
        try {
            return new JcrTermQuery(new Term(FieldNames.LABEL, this.nsMappings.translateName(this.nodeName)));
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
    }

    public void extractTerms(Set<Term> terms) {
    }

    public String toString(String field) {
        return "name() = " + this.nodeName.toString();
    }
}

