/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexMigration;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;

class PersistentIndex
extends AbstractIndex {
    private final String name;
    private IndexListener listener;

    PersistentIndex(String name, Analyzer analyzer, Similarity similarity, DocNumberCache cache, DirectoryManager directoryManager, IndexerIoModeHandler modeHandler) throws IOException {
        super(analyzer, similarity, directoryManager.getDirectory(name), cache, modeHandler);
        this.name = name;
        if (this.isExisting()) {
            IndexMigration.migrate(this, directoryManager);
        }
    }

    @Override
    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    void addIndexes(IndexReader[] readers) throws IOException {
        this.getIndexWriter().addIndexes(readers);
        this.getIndexWriter().maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyIndex(AbstractIndex index) throws IOException {
        index.commit(true);
        byte[] buffer = new byte[1024];
        Directory dir = index.getDirectory();
        Directory dest = this.getDirectory();
        String[] files = dir.listAll();
        for (int i = 0; i < files.length; ++i) {
            try (IndexInput in = dir.openInput(files[i]);
                 IndexOutput out = dest.createOutput(files[i]);){
                int num;
                for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                    num = (int)Math.min(remaining, (long)buffer.length);
                    in.readBytes(buffer, 0, num);
                    out.writeBytes(buffer, num);
                }
                continue;
            }
        }
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        this.releaseWriterAndReaders();
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }
}

