/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;

public class DB2DBInitializer
extends StorageDBInitializer {
    public DB2DBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    @Override
    protected boolean isSequenceExists(final Connection conn, final String sequenceName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return DB2DBInitializer.this.sequenceExists(sequenceName, conn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sequenceExists(String sequenceName, Connection con) {
        boolean bl;
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String query = "SELECT count(*) FROM SYSCAT.SEQUENCES WHERE SYSCAT.SEQUENCES.SEQNAME = '" + sequenceName + "'";
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            bl = trs.next() && trs.getInt(1) >= 1;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQLException occurs while checking the sequence " + sequenceName), (Throwable)e);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                JDBCUtils.freeResources(trs, (Statement)stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return bl2;
        }
        JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
        return bl;
    }
}

