/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.util.IdGenerator;

public class SybaseMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected String SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE;
    protected String SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE_B;
    protected String DELETE_TEMPORARY_TABLE_A;
    protected String DELETE_TEMPORARY_TABLE_B;
    protected PreparedStatement selectLimitOffsetNodesIntoTemporaryTable;
    protected PreparedStatement selectLimitOffsetNodesIntoTemporaryTableB;
    protected PreparedStatement deleteTemporaryTableA;
    protected PreparedStatement deleteTemporaryTableB;

    public SybaseMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    protected String escapeSpecialChars(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '[': 
                case ']': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbol());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_PROPERTY_BY_ID = "select datalength(DATA), I.P_TYPE, V.STORAGE_DESC from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V where I.ID = ? and V.PROPERTY_ID = I.ID";
        this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE = "select TOP ${TOP} I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM into #tempA from " + this.JCR_ITEM + " I (index " + this.JCR_PK_ITEM + ") where I.I_CLASS=1 AND I.ID > ? order by I.ID";
        this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE_B = "select TOP ${TOP} J.* into #tempB from " + this.JCR_ITEM + " J (index " + this.JCR_PK_ITEM + ") where J.I_CLASS=1 AND J.PARENT_ID=?  AND J.N_ORDER_NUM  >= ? order by J.N_ORDER_NUM, J.ID ASC";
        this.FIND_NODES_AND_PROPERTIES = "select #tempA.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P, #tempA where P.PARENT_ID = #tempA.ID and P.I_CLASS=2 and V.PROPERTY_ID=P.ID order by #tempA.ID";
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select #tempB.*,P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA  from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P, #tempB where P.PARENT_ID = #tempB.ID and P.I_CLASS=2 and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by #tempB.N_ORDER_NUM, #tempB.ID";
            this.FIND_LAST_ORDER_NUMBER = "exec " + this.JCR_ITEM_NEXT_VAL + " 'LAST_N_ORDER_NUM', ?, ?";
        }
        this.DELETE_TEMPORARY_TABLE_A = "drop table #tempA";
        this.DELETE_TEMPORARY_TABLE_B = "drop table #tempB";
        this.FIND_WORKSPACE_DATA_SIZE = "select sum(datalength(DATA)) from " + this.JCR_VALUE;
        this.FIND_NODE_DATA_SIZE = "select sum(datalength(DATA)) from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V  where I.PARENT_ID=? and I.I_CLASS=2 and I.ID=V.PROPERTY_ID";
        this.FIND_VALUE_STORAGE_DESC_AND_SIZE = "select datalength(DATA), STORAGE_DESC from " + this.JCR_VALUE + " where PROPERTY_ID=?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        String tempTableAName = "tempdb..a" + IdGenerator.generate();
        boolean tempTableACreated = false;
        try {
            if (!this.dbConnection.getAutoCommit()) {
                this.dbConnection.setAutoCommit(true);
            }
            this.selectLimitOffsetNodesIntoTemporaryTable = this.dbConnection.prepareStatement(this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE.replaceAll("#tempA", tempTableAName).replace("${TOP}", new Integer(offset + limit).toString()));
            if (this.findNodesAndProperties != null) {
                this.findNodesAndProperties.close();
            }
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES.replaceAll("#tempA", tempTableAName));
            this.deleteTemporaryTableA = this.dbConnection.prepareStatement(this.DELETE_TEMPORARY_TABLE_A.replaceAll("#tempA", tempTableAName));
            this.selectLimitOffsetNodesIntoTemporaryTable.setString(1, lastNodeId);
            this.selectLimitOffsetNodesIntoTemporaryTable.execute();
            tempTableACreated = true;
            ResultSet resultSet = this.findNodesAndProperties.executeQuery();
            return resultSet;
        }
        finally {
            if (tempTableACreated) {
                try {
                    this.deleteTemporaryTableA.execute();
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Can not delete temporary table " + tempTableAName));
                }
            }
            if (this.selectLimitOffsetNodesIntoTemporaryTable != null) {
                this.selectLimitOffsetNodesIntoTemporaryTable.close();
            }
            if (this.deleteTemporaryTableA != null) {
                this.deleteTemporaryTableA.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.findChildNodesByParentIdentifier(parentCid, fromOrderNum, offset, limit);
        }
        String tempTableBName = "tempdb..b" + IdGenerator.generate();
        boolean tempTableBCreated = false;
        try {
            if (!this.dbConnection.getAutoCommit()) {
                this.dbConnection.setAutoCommit(true);
            }
            this.selectLimitOffsetNodesIntoTemporaryTableB = this.dbConnection.prepareStatement(this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE_B.replaceAll("#tempB", tempTableBName).replace("${TOP}", new Integer(offset + limit).toString()));
            if (this.findNodesByParentIdLazilyCQ != null) {
                this.findNodesByParentIdLazilyCQ.close();
            }
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replaceAll("#tempB", tempTableBName));
            this.deleteTemporaryTableB = this.dbConnection.prepareStatement(this.DELETE_TEMPORARY_TABLE_B.replaceAll("#tempB", tempTableBName));
            this.selectLimitOffsetNodesIntoTemporaryTableB.setString(1, parentCid);
            this.selectLimitOffsetNodesIntoTemporaryTableB.setInt(2, fromOrderNum);
            this.selectLimitOffsetNodesIntoTemporaryTableB.execute();
            tempTableBCreated = true;
            ResultSet resultSet = this.findNodesByParentIdLazilyCQ.executeQuery();
            return resultSet;
        }
        finally {
            if (tempTableBCreated) {
                try {
                    this.deleteTemporaryTableB.execute();
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Can not delete temporary table " + tempTableBName));
                }
            }
            if (this.selectLimitOffsetNodesIntoTemporaryTableB != null) {
                this.selectLimitOffsetNodesIntoTemporaryTableB.close();
            }
            if (this.deleteTemporaryTableB != null) {
                this.deleteTemporaryTableB.close();
            }
        }
    }

    @Override
    protected ResultSet findLastOrderNumber(int localMaxOrderNumber, boolean increment) throws SQLException {
        if (this.findLastOrderNumber == null) {
            this.findLastOrderNumber = this.dbConnection.prepareCall(this.FIND_LAST_ORDER_NUMBER);
        } else {
            this.findLastOrderNumber.clearParameters();
        }
        int value = increment ? 1 : 0;
        this.findLastOrderNumber.setInt(1, localMaxOrderNumber);
        this.findLastOrderNumber.setInt(2, value);
        this.findLastOrderNumber.execute();
        return this.findLastOrderNumber.getResultSet();
    }
}

