/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.internal.storage.AggregatedFeatureSet;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;

public class ConcatenatedFeatureSet
extends AggregatedFeatureSet {
    private final List<FeatureSet> sources;
    private final DefaultFeatureType commonType;

    private ConcatenatedFeatureSet(FeatureSet[] featureSetArray, ConcatenatedFeatureSet concatenatedFeatureSet) {
        super(concatenatedFeatureSet.listeners);
        this.sources = UnmodifiableArrayList.wrap((Object[])featureSetArray);
        this.commonType = concatenatedFeatureSet.commonType;
    }

    protected ConcatenatedFeatureSet(StoreListeners storeListeners, FeatureSet[] featureSetArray) throws DataStoreException {
        super(storeListeners);
        for (int i = 0; i < featureSetArray.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"sources", (int)i, (Object)featureSetArray[i]);
        }
        this.sources = UnmodifiableArrayList.wrap((Object[])featureSetArray);
        DefaultFeatureType[] defaultFeatureTypeArray = new DefaultFeatureType[featureSetArray.length];
        for (int i = 0; i < defaultFeatureTypeArray.length; ++i) {
            defaultFeatureTypeArray[i] = featureSetArray[i].getType();
        }
        this.commonType = Features.findCommonParent(Arrays.asList(defaultFeatureTypeArray));
        if (this.commonType == null) {
            throw new DataStoreContentException("Cannot find a common super type across all feature sets to concatenate");
        }
    }

    public static FeatureSet create(FeatureSet ... featureSetArray) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty((String)"sources", (Object[])featureSetArray);
        if (featureSetArray.length == 1) {
            FeatureSet featureSet = featureSetArray[0];
            ArgumentChecks.ensureNonNullElement((String)"sources", (int)0, (Object)featureSet);
            return featureSet;
        }
        return new ConcatenatedFeatureSet(null, (FeatureSet[])featureSetArray.clone());
    }

    public static FeatureSet create(Collection<? extends FeatureSet> collection) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"sources", collection);
        int n = collection.size();
        switch (n) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, (Object)"sources"));
            }
            case 1: {
                FeatureSet featureSet = (FeatureSet)CollectionsExt.first(collection);
                ArgumentChecks.ensureNonNullElement((String)"sources", (int)0, (Object)featureSet);
                return featureSet;
            }
        }
        return new ConcatenatedFeatureSet(null, collection.toArray(new FeatureSet[n]));
    }

    final List<FeatureSet> dependencies() {
        return this.sources;
    }

    @Override
    public DefaultFeatureType getType() {
        return this.commonType;
    }

    @Override
    public OptionalLong getFeatureCount() {
        long l = 0L;
        for (FeatureSet featureSet : this.sources) {
            long l2;
            OptionalLong optionalLong;
            if (featureSet instanceof AbstractFeatureSet && (optionalLong = ((AbstractFeatureSet)featureSet).getFeatureCount()).isPresent() && (l2 = optionalLong.getAsLong()) >= 0L) {
                if ((l += l2) >= 0L) continue;
                l = Long.MAX_VALUE;
                break;
            }
            return OptionalLong.empty();
        }
        return OptionalLong.of(l);
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) {
        Stream stream = bl ? this.sources.parallelStream() : this.sources.stream();
        return stream.flatMap(featureSet -> {
            try {
                return featureSet.features(bl);
            }
            catch (DataStoreException dataStoreException) {
                throw new BackingStoreException((Throwable)dataStoreException);
            }
        });
    }

    @Override
    public FeatureSet subset(Query query) throws DataStoreException {
        FeatureSet[] featureSetArray = new FeatureSet[this.sources.size()];
        boolean bl = false;
        for (int i = 0; i < featureSetArray.length; ++i) {
            FeatureSet featureSet = this.sources.get(i);
            featureSetArray[i] = featureSet.subset(query);
            bl |= featureSetArray[i] != featureSet;
        }
        return bl ? new ConcatenatedFeatureSet(featureSetArray, this) : this;
    }
}

