/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.router;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouterConfig;
import org.exoplatform.social.common.router.regex.ExoMatcher;
import org.exoplatform.social.common.router.regex.ExoPattern;
import org.picocontainer.Startable;

public class ExoRouter
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(ExoRouter.class);
    static ExoPattern defaultRoutePattern = ExoPattern.compile("^({path}.*/[^\\s]*)\\s+({action}[^\\s(]+)({params}.+)?(\\s*)$");
    public static List<Route> routes = new CopyOnWriteArrayList<Route>();

    public static void reset() {
        routes.clear();
    }

    public void addRoutes(ExoRouterConfig routerConfig) {
        Map<String, String> routeMapping = routerConfig.getRouteMapping();
        for (Map.Entry<String, String> entry : routeMapping.entrySet()) {
            ExoRouter.addRoute(entry.getValue(), entry.getKey());
        }
    }

    public static void addRoute(String path, String action) {
        ExoRouter.addRoute(path, action, null);
    }

    public static void addRoute(String path, String action, String params) {
        ExoRouter.appendRoute(path, action, params);
    }

    public static void appendRoute(String path, String action, String params) {
        int position = routes.size();
        routes.add(position, ExoRouter.getRoute(path, action, params));
    }

    public static Route getRoute(String path, String action, String params) {
        return ExoRouter.getRoute(path, action, params, null, 0);
    }

    public static Route getRoute(String path, String action) {
        return ExoRouter.getRoute(path, action, null, null, 0);
    }

    public static Route getRoute(String path, String action, String params, String sourceFile, int line) {
        Route route = new Route();
        route.path = path.replace("//", "/");
        route.action = action;
        route.routesFile = sourceFile;
        route.routesFileLine = line;
        route.addParams(params);
        route.compute();
        return route;
    }

    public static void prependRoute(String path, String action, String params) {
        routes.add(0, ExoRouter.getRoute(path, action, params));
    }

    public static void prependRoute(String path, String action) {
        routes.add(0, ExoRouter.getRoute(path, action));
    }

    public static Route route(String path) {
        for (Route route : routes) {
            Map<String, String> args = route.matches(path);
            if (args == null) continue;
            route.localArgs = args;
            return route;
        }
        return null;
    }

    public static ActionBuilder reverse(String action, Map<String, Object> args) {
        HashMap<String, Object> argsbackup = new HashMap<String, Object>(args);
        for (Route route : routes) {
            ExoMatcher matcher;
            if (route.actionPattern == null || !(matcher = route.actionPattern.matcher(action)).matches()) continue;
            for (String group : route.actionArgs) {
                String v = matcher.group(group);
                if (v == null) continue;
                args.put(group, v.toLowerCase());
            }
            ArrayList<String> inPathArgs = new ArrayList<String>(16);
            boolean allRequiredArgsAreHere = true;
            for (Route.ParamArg arg : route.args) {
                inPathArgs.add(arg.name);
                Iterator<Map.Entry<String, Object>> value = args.get(arg.name);
                if (value == null || value.toString().startsWith(":") || arg.constraint.matches(value.toString())) continue;
                allRequiredArgsAreHere = false;
                break;
            }
            if (!allRequiredArgsAreHere) continue;
            StringBuilder queryString = new StringBuilder();
            String path = route.path;
            if (path.endsWith("/?")) {
                path = path.substring(0, path.length() - 2);
            }
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (inPathArgs.contains(key) && value != null) {
                    path = path.replaceAll("\\{(<[^>]+>)?" + key + "\\}", value.toString().replace("$", "\\$").replace("%3A", ":").replace("%40", "@"));
                    continue;
                }
                if (value == null) continue;
                try {
                    queryString.append(URLEncoder.encode(key, "UTF-8"));
                    queryString.append("=");
                    if (value.toString().startsWith(":")) {
                        queryString.append(value.toString());
                    } else {
                        queryString.append(URLEncoder.encode(value.toString(), "UTF-8"));
                    }
                    queryString.append("&");
                }
                catch (UnsupportedEncodingException ex) {
                    LOG.debug((Object)("Unsupported encoding error: " + ex));
                }
            }
            String qs = queryString.toString();
            if (qs.endsWith("&")) {
                qs = qs.substring(0, qs.length() - 1);
            }
            ActionBuilder actionDefinition = new ActionBuilder();
            actionDefinition.url = qs.length() == 0 ? path : path + "?" + qs;
            actionDefinition.action = action;
            actionDefinition.args = argsbackup;
            return actionDefinition;
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public static class Route {
        public String path;
        public String action;
        ExoPattern actionPattern;
        List<String> actionArgs = new ArrayList<String>(3);
        ExoPattern pattern;
        public String routesFile;
        List<ParamArg> args = new ArrayList<ParamArg>(3);
        Map<String, String> staticArgs = new HashMap<String, String>(3);
        public Map<String, String> localArgs = null;
        public int routesFileLine;
        static ExoPattern customRegexPattern = ExoPattern.compile("\\{([a-zA-Z_][a-zA-Z_0-9]*)\\}");
        static ExoPattern argsPattern = ExoPattern.compile("\\{<([^>]+)>([a-zA-Z_0-9]+)\\}");
        static ExoPattern paramPattern = ExoPattern.compile("([a-zA-Z_0-9]+):'(.*)'");

        public void compute() {
            String patternString = this.path;
            patternString = customRegexPattern.matcher(patternString).replaceAll("\\{<[^/]+>$1\\}");
            ExoMatcher matcher = argsPattern.matcher(patternString);
            while (matcher.find()) {
                ParamArg arg = new ParamArg();
                arg.name = matcher.group(2);
                arg.constraint = ExoPattern.compile(matcher.group(1));
                this.args.add(arg);
            }
            patternString = argsPattern.matcher(patternString).replaceAll("({$2}$1)");
            this.pattern = ExoPattern.compile(patternString);
            patternString = this.action;
            patternString = patternString.replace(".", "[.]");
            for (ParamArg arg : this.args) {
                if (!patternString.contains("{" + arg.name + "}")) continue;
                patternString = patternString.replace("{" + arg.name + "}", "({" + arg.name + "}" + arg.constraint.toString() + ")");
                this.actionArgs.add(arg.name);
            }
            this.actionPattern = ExoPattern.compile(patternString, 2);
        }

        public void addParams(String params) {
            if (params == null || params.length() < 1) {
                return;
            }
            params = params.substring(1, params.length() - 1);
            for (String param : params.split(",")) {
                ExoMatcher matcher = paramPattern.matcher(param);
                if (matcher.matches()) {
                    this.staticArgs.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                LOG.warn((Object)"Ignoring %s (static params must be specified as key:'value',...)");
            }
        }

        public Map<String, String> matches(String path) {
            ExoMatcher matcher = this.pattern.matcher(path);
            if (matcher.matches()) {
                HashMap<String, String> localArgs = new HashMap<String, String>();
                for (ParamArg arg : this.args) {
                    if (arg.defaultValue != null) continue;
                    localArgs.put(arg.name, matcher.group(arg.name));
                }
                return localArgs;
            }
            return null;
        }

        static class ParamArg {
            String name;
            ExoPattern constraint;
            String defaultValue;

            ParamArg() {
            }
        }
    }

    public static class ActionBuilder {
        public String url;
        public String action;
        public Map<String, Object> args;

        public ActionBuilder add(String key, Object value) {
            this.args.put(key, value);
            return ExoRouter.reverse(this.action, this.args);
        }

        public ActionBuilder remove(String key) {
            this.args.remove(key);
            return ExoRouter.reverse(this.action, this.args);
        }

        public ActionBuilder addRef(String fragment) {
            this.url = this.url + "#" + fragment;
            return this;
        }

        public String toString() {
            return this.url;
        }
    }
}

