/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.EntityNotFoundException;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.Util;
import org.gatein.api.common.i18n.LocalizedString;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.internal.Parameters;
import org.gatein.api.navigation.ApiFilteredNode;
import org.gatein.api.navigation.ApiNodeChange;
import org.gatein.api.navigation.FilteredNode;
import org.gatein.api.navigation.MultiPathNodeVisitor;
import org.gatein.api.navigation.NavigationImpl;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.NodeVisitor;
import org.gatein.api.navigation.NodeVisitorScope;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.navigation.ObjectFactory;
import org.gatein.api.navigation.PublicationDate;
import org.gatein.api.navigation.Visibility;
import org.gatein.api.page.PageId;
import org.gatein.api.site.SiteId;

public class ApiNode
implements Node {
    transient NodeContext<ApiNode> context;
    transient NavigationImpl navigation;
    private LocalizedString displayName;
    private String resolvedDisplayName;
    private String resolvedURI;
    private boolean displayNameChanged;
    private final SiteId siteId;

    ApiNode(NavigationImpl navigation, NodeContext<ApiNode> context) {
        this.navigation = navigation;
        this.siteId = navigation.getSiteId();
        this.context = context;
    }

    public Node addChild(int index, String childName) {
        this.checkChildrenLoaded();
        Parameters.requireNonNull((Object)childName, (String)"childName");
        return (Node)this.context.add(Integer.valueOf(index), childName).getNode();
    }

    public Node addChild(String childName) {
        this.checkChildrenLoaded();
        Parameters.requireNonNull((Object)childName, (String)"childName");
        if (this.hasChild(childName)) {
            throw new EntityAlreadyExistsException("child " + childName + " already exists");
        }
        return (Node)this.context.add(null, childName).getNode();
    }

    public FilteredNode filter() {
        return new ApiFilteredNode(this.navigation, this.context);
    }

    public Node getChild(int index) {
        this.checkChildrenLoaded();
        return this.context.isExpanded() ? (Node)this.context.getNode(index) : null;
    }

    public Node getChild(String childName) {
        Parameters.requireNonNull((Object)childName, (String)"childName");
        this.checkChildrenLoaded();
        return this.context.isExpanded() ? (Node)this.context.getNode(childName) : null;
    }

    public int getChildCount() {
        this.checkChildrenLoaded();
        return this.context.getNodeSize();
    }

    public Node getNode(String ... nodePath) {
        return this.getNode(NodePath.path((String[])nodePath));
    }

    public Node getNode(NodePath nodePath) {
        this.checkChildrenLoaded();
        Parameters.requireNonNull((Object)nodePath, (String)"nodePath");
        ApiNode node = this;
        for (String name : nodePath) {
            if ((node = node.getChild(name)) != null) continue;
            return null;
        }
        return node;
    }

    public String getIconName() {
        return this.context.getState().getIcon();
    }

    public String getDisplayName() {
        if (this.resolvedDisplayName == null) {
            String simple = this.context.getState().getLabel();
            this.resolvedDisplayName = simple != null && !ExpressionUtil.isResourceBindingExpression((String)simple) ? simple : this.navigation.resolve(this.context);
        }
        return this.resolvedDisplayName;
    }

    public LocalizedString getDisplayNames() {
        if (this.displayName == null) {
            String simple = this.context.getState().getLabel();
            if (simple != null) {
                this.displayName = new LocalizedString(simple);
            } else if (this.context.getId() != null) {
                Map<Locale, State> descriptions = this.navigation.loadDescriptions(this.context.getId());
                this.displayName = ObjectFactory.createLocalizedString(descriptions);
            }
        }
        return this.displayName;
    }

    public String getName() {
        return this.isRoot() ? null : this.context.getName();
    }

    public NodePath getNodePath() {
        NodePath path;
        String name = this.getName();
        ApiNode parent = (ApiNode)this.context.getParentNode();
        NodePath nodePath = path = this.isRoot() ? NodePath.root() : NodePath.path((String[])new String[]{name});
        if (parent != null) {
            path = parent.getNodePath().append(path);
        }
        return path;
    }

    public PageId getPageId() {
        return Util.from(this.context.getState().getPageRef());
    }

    public Node getParent() {
        return (Node)this.context.getParentNode();
    }

    public String getURI() {
        if (this.resolvedURI == null) {
            this.resolvedURI = this.isRoot() ? PortalRequest.getInstance().getURIResolver().resolveURI(this.siteId) : this.getParent().getURI() + "/" + this.getName();
        }
        return this.resolvedURI;
    }

    void clearCached() {
        this.resolvedDisplayName = null;
        this.resolvedURI = null;
    }

    public Visibility getVisibility() {
        return ObjectFactory.createVisibility(this.context.getState());
    }

    public boolean hasChild(String childName) {
        return this.getChild(childName) != null;
    }

    public int indexOf(String childName) {
        ApiNode node = (ApiNode)this.getChild(childName);
        return node == null ? -1 : node.context.getIndex();
    }

    public boolean isChildrenLoaded() {
        return this.context.isExpanded();
    }

    public boolean isRoot() {
        return this.context.getParent() == null;
    }

    public boolean isVisible() {
        return this.getVisibility().isVisible();
    }

    public Iterator<Node> iterator() {
        return new ApiNodeModelIterator();
    }

    public void moveTo(int index) {
        this.checkNonRoot();
        if (this.context.getIndex() < index) {
            ++index;
        }
        ((NodeContext)this.context.getParent()).add(Integer.valueOf(index), this.context);
    }

    public void moveTo(int index, Node parent) {
        this.moveTo(new Integer(index), parent);
    }

    public void moveTo(Node parent) {
        this.moveTo(null, parent);
    }

    private void moveTo(Integer index, Node parent) {
        this.checkNonRoot();
        ((ApiNode)parent).checkChildrenLoaded();
        if (this.getNodePath().isParent(parent.getNodePath())) {
            throw new IllegalArgumentException("Can't move node to a child node of itself");
        }
        ApiNode root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (((ApiNode)root.getNode(parent.getNodePath())).getContext() != ((ApiNode)parent).getContext()) {
            throw new IllegalArgumentException("Can't move node to a different branch");
        }
        ((ApiNode)parent).context.add(index, this.context);
    }

    public boolean removeChild(String childName) {
        this.checkChildrenLoaded();
        if (!this.hasChild(childName)) {
            throw new EntityNotFoundException("Cannot remove child '" + childName + "' because it does not exist for parent node " + this.getNodePath());
        }
        return this.context.removeNode(childName);
    }

    public void setName(String name) throws IllegalArgumentException {
        Parameters.requireNonNull((Object)name, (String)"name");
        this.context.setName(name);
    }

    public void setIconName(String iconName) {
        this.checkNonRoot();
        this.setState(this.getStateBuilder().icon(iconName));
    }

    public void setDisplayName(String displayName) {
        Parameters.requireNonNull((Object)displayName, (String)"displayName");
        this.setDisplayNames(new LocalizedString(displayName));
    }

    public void setDisplayNames(LocalizedString displayName) {
        this.checkNonRoot();
        if (displayName == null && this.displayName == null) {
            return;
        }
        if (displayName != null || !this.displayName.equals((Object)displayName)) {
            if (displayName != null && !displayName.isLocalized()) {
                this.setState(this.getStateBuilder().label(displayName.getValue()));
            } else {
                this.setState(this.getStateBuilder().label(null));
            }
            this.displayName = displayName;
            this.resolvedDisplayName = null;
            this.displayNameChanged = true;
        }
    }

    public void setPageId(PageId pageId) {
        this.checkNonRoot();
        this.setState(this.getStateBuilder().pageRef(Util.from(pageId)));
    }

    public void setVisibility(boolean visible) {
        this.checkNonRoot();
        NodeState.Builder b = this.getStateBuilder();
        if (visible) {
            b.visibility(org.exoplatform.portal.mop.Visibility.DISPLAYED);
        } else {
            b.visibility(org.exoplatform.portal.mop.Visibility.HIDDEN);
        }
        this.setState(b);
    }

    public void setVisibility(PublicationDate publicationDate) {
        this.checkNonRoot();
        Parameters.requireNonNull((Object)publicationDate, (String)"publicationDate");
        long start = publicationDate.getStart() != null ? publicationDate.getStart().getTime() : -1L;
        long end = publicationDate.getEnd() != null ? publicationDate.getEnd().getTime() : -1L;
        this.setState(this.getStateBuilder().startPublicationTime(start).endPublicationTime(end).visibility(org.exoplatform.portal.mop.Visibility.TEMPORAL));
    }

    public void setVisibility(Visibility visibility) {
        this.checkNonRoot();
        Parameters.requireNonNull((Object)visibility, (String)"visibility");
        if (visibility.getStatus() == Visibility.Status.PUBLICATION) {
            this.setVisibility(visibility.getPublicationDate());
        } else {
            this.setState(this.getStateBuilder().startPublicationTime(-1L).endPublicationTime(-1L).visibility(ObjectFactory.createVisibility(visibility.getStatus())));
        }
    }

    public void sort(Comparator<Node> comparator) {
        Parameters.requireNonNull(comparator, (String)"comparator");
        if (this.context.isExpanded()) {
            ApiNode[] a = new ApiNode[this.context.getNodeSize()];
            for (NodeContext c = (NodeContext)this.context.getFirst(); c != null; c = (NodeContext)c.getNext()) {
                a[c.getIndex()] = (ApiNode)c.getNode();
            }
            Arrays.sort(a, comparator);
            for (int i = 0; i < a.length; ++i) {
                ApiNode n = a[i];
                NodeContext<ApiNode> c = n.getContext();
                if (c.getIndex() == i) continue;
                ((ApiNode)c.getNode()).moveTo(i);
            }
        }
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder(this.getClass()).add("name", (Object)this.getName()).add("path", (Object)this.getNodePath()).add("visibility", (Object)this.getVisibility()).add("iconName", (Object)this.getIconName()).add("pageId", (Object)this.getPageId()).toString();
    }

    NodeContext<ApiNode> getContext() {
        return this.context;
    }

    SiteId getSiteId() {
        return this.siteId;
    }

    boolean isDisplayNameChanged() {
        return this.displayNameChanged;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean hasChanges;
        NodeVisitor visitor;
        Portal portal;
        in.defaultReadObject();
        NodePath nodePath = (NodePath)in.readObject();
        ApiNode parent = (ApiNode)in.readObject();
        boolean expanded = in.readBoolean();
        PortalRequest request = PortalRequest.getInstance();
        Portal portal2 = portal = request == null ? null : request.getPortal();
        if (portal != null) {
            this.navigation = (NavigationImpl)portal.getNavigation(this.siteId);
            if (this.navigation == null) {
                throw new IOException("Could not retrieve navigation for site " + this.siteId);
            }
        } else {
            throw new IOException("Could not retrieve portal API during deserialization.");
        }
        if (parent != null) {
            this.context = parent.context.get(nodePath.getLastSegment());
            if (expanded) {
                this.navigation.rebaseNodeContext(this.context, new NodeVisitorScope(Nodes.visitChildren()), null);
            }
        } else {
            visitor = expanded ? Nodes.visitChildren() : Nodes.visitNone();
            this.context = this.navigation.getNodeContext(nodePath, visitor);
        }
        if (expanded && parent == null) {
            visitor = new MultiPathNodeVisitor();
            this.readTree((MultiPathNodeVisitor)visitor, in);
            this.navigation.rebaseNodeContext(this.context, new NodeVisitorScope(visitor), null);
        }
        if ((hasChanges = in.readBoolean()) && parent == null) {
            List changes = (List)in.readObject();
            for (ApiNodeChange change : changes) {
                change.apply(this);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getNodePath());
        ApiNode parent = this.context.getParent() != null ? (ApiNode)((NodeContext)this.context.getParent()).getNode() : null;
        out.writeObject(parent);
        boolean expanded = this.context.isExpanded();
        out.writeBoolean(expanded);
        if (expanded && parent == null) {
            this.writeTree(this, out);
        }
        boolean hasChanges = this.context.hasChanges() || this.displayNameChanged;
        out.writeBoolean(hasChanges);
        if (hasChanges && parent == null) {
            ArrayList<ApiNodeChange> changes = new ArrayList<ApiNodeChange>();
            for (NodeChange change : this.context.getChanges()) {
                if (change instanceof NodeChange.Created) {
                    NodeChange.Created created = (NodeChange.Created)change;
                    changes.add(new ApiNodeChange.Created((NodeChange.Created<NodeContext<ApiNode>>)created));
                    continue;
                }
                if (change instanceof NodeChange.Destroyed) {
                    NodeChange.Destroyed destroyed = (NodeChange.Destroyed)change;
                    changes.add(new ApiNodeChange.Destroyed((NodeChange.Destroyed<NodeContext<ApiNode>>)destroyed));
                    continue;
                }
                if (change instanceof NodeChange.Moved) {
                    NodeChange.Moved moved = (NodeChange.Moved)change;
                    changes.add(new ApiNodeChange.Moved((NodeChange.Moved<NodeContext<ApiNode>>)moved));
                    continue;
                }
                if (change instanceof NodeChange.Renamed) {
                    NodeChange.Renamed renamed = (NodeChange.Renamed)change;
                    changes.add(new ApiNodeChange.Renamed((NodeChange.Renamed<NodeContext<ApiNode>>)renamed));
                    continue;
                }
                if (change instanceof NodeChange.Updated) {
                    NodeChange.Updated updated = (NodeChange.Updated)change;
                    changes.add(new ApiNodeChange.Updated((NodeChange.Updated<NodeContext<ApiNode>>)updated));
                    continue;
                }
                throw new IOException("Cannot serialize: Non-compatible node change object " + change);
            }
            out.writeObject(changes);
        }
    }

    private void readTree(MultiPathNodeVisitor visitor, ObjectInputStream in) throws IOException, ClassNotFoundException {
        NodePath path = (NodePath)in.readObject();
        visitor.add(path);
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            this.readTree(visitor, in);
        }
    }

    private void writeTree(Node node, ObjectOutputStream out) throws IOException {
        out.writeObject(node.getNodePath());
        if (node.isChildrenLoaded()) {
            out.writeInt(node.getChildCount());
            for (Node child : node) {
                this.writeTree(child, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    private void checkNonRoot() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Operation not supported on root node");
        }
    }

    private void checkChildrenLoaded() {
        if (!this.context.isExpanded()) {
            throw new IllegalStateException("Children are not loaded");
        }
    }

    private NodeState.Builder getStateBuilder() {
        return new NodeState.Builder(this.context.getState());
    }

    private void setState(NodeState.Builder builder) {
        this.context.setState(builder.build());
    }

    private class ApiNodeModelIterator
    implements Iterator<Node> {
        private Iterator<ApiNode> itr;
        private ApiNode last;

        private ApiNodeModelIterator() {
            this.itr = ApiNode.this.context.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            this.last = this.itr.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.last.context.remove();
        }
    }
}

