/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.page;

import java.io.Serializable;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.gatein.api.Util;
import org.gatein.api.internal.Parameters;
import org.gatein.api.page.Page;
import org.gatein.api.page.PageId;
import org.gatein.api.security.Permission;
import org.gatein.api.site.SiteId;

public class PageImpl
implements Page,
Serializable {
    private static final long serialVersionUID = 4541337067269269259L;
    private PageKey key;
    private PageState state;
    private boolean create;

    public PageImpl(PageContext pageContext) {
        this.key = pageContext.getKey();
        this.state = pageContext.getState();
    }

    public PageId getId() {
        return Util.from(this.key);
    }

    public SiteId getSiteId() {
        return Util.from(this.key.getSite());
    }

    public String getName() {
        return this.key.getName();
    }

    public String getDescription() {
        return this.state.getDescription();
    }

    public void setDescription(String description) {
        this.setState(this.builder().description(description));
    }

    public void setDisplayName(String displayName) {
        this.setState(this.builder().displayName(displayName));
    }

    public String getDisplayName() {
        return this.state.getDisplayName();
    }

    public Permission getAccessPermission() {
        return Util.from(this.state.getAccessPermissions());
    }

    public void setAccessPermission(Permission permission) {
        Parameters.requireNonNull((Object)permission, (String)"permission", (String)"To allow access to everyone use Permission.everyone()");
        this.setState(this.builder().accessPermissions(Util.from(permission)));
    }

    public Permission getEditPermission() {
        return Util.from(this.state.getEditPermission());
    }

    public void setEditPermission(Permission permission) {
        Parameters.requireNonNull((Object)permission, (String)"permission", (String)"To allow edit for everyone use Permission.everyone()");
        String[] permissions = Util.from(permission);
        if (permissions.length != 1) {
            throw new IllegalArgumentException("Invalid permission. Only one membership is allowed for an edit permission");
        }
        this.setState(this.builder().editPermission(permissions[0]));
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public int compareTo(Page page) {
        return this.getName().compareTo(page.getName());
    }

    public PageContext getPageContext() {
        return new PageContext(this.key, this.state);
    }

    private PageState.Builder builder() {
        return this.state.builder();
    }

    private void setState(PageState.Builder builder) {
        this.state = builder.build();
    }
}

