/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.util;

import com.ibm.icu.text.Transliterator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.Version;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.legacy.search.data.SearchResult;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FolderNode;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.search.DocumentFileSearchResult;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class JCRDocumentsUtil {
    private static final Log LOG = ExoLogger.getLogger(JCRDocumentsUtil.class);
    private static final String DEFAULT_GROUPS_HOME_PATH = "/Groups";
    public static final String GROUPS_PATH_ALIAS = "groupsPath";
    public static final String DOCUMENTS_NODE = "Documents";
    private static final String JCR_DATASOURCE_NAME = "jcr";
    public static final String USER_PRIVATE_ROOT_NODE = "Private";
    public static final String USER_PUBLIC_ROOT_NODE = "Public";
    private static final String SPACE_PATH_PREFIX = "/Groups/spaces/";
    protected static final Map<DocumentSortField, String> SORT_FIELDS_ES_CORRESPONDING = new EnumMap<DocumentSortField, String>(DocumentSortField.class);
    protected static final Map<DocumentSortField, String> SORT_FIELDS_JCR_CORRESPONDING = new EnumMap<DocumentSortField, String>(DocumentSortField.class);
    private static String groupsPath;

    private JCRDocumentsUtil() {
    }

    public static Node getGroupNode(NodeHierarchyCreator nodeHierarchyCreator, Session session, String groupId) throws RepositoryException {
        String groupsHomePath = JCRDocumentsUtil.getGroupsPath(nodeHierarchyCreator);
        String groupPath = groupsHomePath + groupId + "/Documents";
        if (session.itemExists(groupPath)) {
            return (Node)session.getItem(groupPath);
        }
        return null;
    }

    public static String getGroupsPath(NodeHierarchyCreator nodeHierarchyCreator) {
        if (groupsPath != null) {
            return groupsPath;
        }
        groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_PATH_ALIAS);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)groupsPath)) {
            groupsPath = DEFAULT_GROUPS_HOME_PATH;
        }
        return groupsPath;
    }

    public static List<FileNode> toFileNodes(IdentityManager identityManager, NodeIterator nodeIterator, Identity aclIdentity, Session session, SpaceService spaceService, boolean includeHiddenFiles) throws RepositoryException {
        ArrayList<FileNode> fileNodes = new ArrayList<FileNode>();
        JCRDeleteFileStorage jCRDeleteFileStorage = (JCRDeleteFileStorage)CommonsUtils.getService(JCRDeleteFileStorage.class);
        Map documetsToDelete = jCRDeleteFileStorage.getDocumentsToDelete();
        while (nodeIterator.hasNext()) {
            String sourceID = "";
            String sourceMimeType = "";
            Node node = nodeIterator.nextNode();
            if (documetsToDelete.containsKey(((NodeImpl)node).getIdentifier())) continue;
            try {
                FileNode fileNode;
                Node sourceNode = null;
                if (node.isNodeType("exo:symlink")) {
                    sourceID = node.getProperty("exo:uuid").getString();
                    sourceNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceID);
                    if (sourceNode == null) continue;
                    if (sourceNode.isNodeType("nt:folder") || sourceNode.isNodeType("nt:unstructured")) {
                        List<FileNode> files;
                        if (node.getPath().contains(sourceNode.getPath()) || (files = JCRDocumentsUtil.toFileNodes(identityManager, sourceNode.getNodes(), aclIdentity, session, spaceService, includeHiddenFiles)).isEmpty()) continue;
                        fileNodes.addAll(files);
                        continue;
                    }
                    if (sourceNode.isNodeType("exo:hiddenable") && !includeHiddenFiles) continue;
                    sourceMimeType = JCRDocumentsUtil.getMimeType(sourceNode);
                    fileNode = JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, sourceID, spaceService);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceMimeType)) {
                        fileNode.setMimeType(sourceMimeType);
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileNode.getMimeType())) continue;
                    fileNodes.add(fileNode);
                    continue;
                }
                if (node.isNodeType("exo:hiddenable") && !includeHiddenFiles || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(fileNode = JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, sourceID, spaceService)).getMimeType())) continue;
                fileNodes.add(fileNode);
            }
            catch (RepositoryException repositoryException) {
                LOG.warn((Object)"Cannot check if the current node is a symlink");
            }
        }
        return fileNodes;
    }

    public static List<AbstractNode> toNodes(IdentityManager identityManager, Session session, NodeIterator nodeIterator, Identity aclIdentity, SpaceService spaceService, boolean includeHiddenFiles, DocumentFolderFilter filter) {
        ArrayList<AbstractNode> fileNodes = new ArrayList<AbstractNode>();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            String sourceID = "";
            Node sourceNode = node;
            try {
                if (node.isNodeType("exo:symlink") && (sourceNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceID = node.getProperty("exo:uuid").getString())) == null) continue;
                if ((sourceNode.isNodeType("nt:folder") || sourceNode.isNodeType("nt:unstructured")) && !node.isNodeType("exo:hiddenable") && !includeHiddenFiles) {
                    FolderNode folderNode = JCRDocumentsUtil.toFolderNode(identityManager, aclIdentity, node, sourceID, spaceService);
                    fileNodes.add((AbstractNode)folderNode);
                }
                if (!sourceNode.isNodeType("nt:file") || node.isNodeType("exo:hiddenable") || includeHiddenFiles) continue;
                FileNode fileNode = JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, sourceID, spaceService);
                fileNode.setMimeType(JCRDocumentsUtil.getMimeType(sourceNode));
                fileNodes.add((AbstractNode)fileNode);
            }
            catch (RepositoryException e) {
                LOG.warn("Error getting Folder Node for search result with path {}", new Object[]{node, e});
            }
        }
        fileNodes.sort((o1, o2) -> {
            if (o1.isFolder() && o2.isFolder() || !o1.isFolder() && !o2.isFolder()) {
                if (filter.getSortField().equals((Object)DocumentSortField.MODIFIED_DATE)) {
                    Date modifiedDateO1 = new Date(o1.getModifiedDate());
                    Date modifiedDateO2 = new Date(o2.getModifiedDate());
                    if (filter.isAscending()) {
                        return modifiedDateO1.compareTo(modifiedDateO2);
                    }
                    return modifiedDateO1.compareTo(modifiedDateO1);
                }
                if (filter.getSortField().equals((Object)DocumentSortField.CREATED_DATE)) {
                    Date createdDateO1 = new Date(o1.getCreatedDate());
                    Date createdDateO2 = new Date(o2.getCreatedDate());
                    if (filter.isAscending()) {
                        return createdDateO1.compareTo(createdDateO2);
                    }
                    return createdDateO2.compareTo(createdDateO1);
                }
                if (filter.isAscending()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
            if (o1.isFolder()) {
                return -1;
            }
            return 1;
        });
        return fileNodes;
    }

    public static FolderNode toFolderNode(IdentityManager identityManager, Identity aclIdentity, Node node, String sourceID, SpaceService spaceService) {
        try {
            if (node == null) {
                return null;
            }
            FolderNode folderNode = new FolderNode();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceID)) {
                folderNode.setSourceID(sourceID);
            }
            folderNode.setDatasource(JCR_DATASOURCE_NAME);
            folderNode.setPath(node.getPath());
            folderNode.setCloudDriveFolder(node.hasProperty("ecd:connected"));
            JCRDocumentsUtil.retrieveFileProperties(identityManager, node, aclIdentity, (AbstractNode)folderNode, spaceService);
            return folderNode;
        }
        catch (Exception e) {
            try {
                LOG.warn("Error computing Folder Node for search result with path {}", new Object[]{node.getPath(), e});
            }
            catch (Exception e1) {
                LOG.warn("Error computing Folder Node for search result with path {}", new Object[]{node, e});
            }
            return null;
        }
    }

    public static FileNode toFileNode(IdentityManager identityManager, Session session, Identity aclIdentity, SearchResult searchResult, SpaceService spaceService) {
        DocumentFileSearchResult fileSearchResult = (DocumentFileSearchResult)searchResult;
        try {
            FileNode fileNode = new FileNode();
            Node node = JCRDocumentsUtil.getNode(session, fileNode, fileSearchResult);
            JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, fileNode, spaceService);
            return fileNode;
        }
        catch (Exception e) {
            LOG.warn("Error computing File Node for search result with id {}", new Object[]{fileSearchResult.getId(), e});
            return null;
        }
    }

    public static FileNode toFileNode(IdentityManager identityManager, Identity aclIdentity, Node node, String sourceID, SpaceService spaceService) {
        if (node == null) {
            return null;
        }
        FileNode fileNode = new FileNode();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceID)) {
            fileNode.setSourceID(sourceID);
        }
        JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, fileNode, spaceService);
        return fileNode;
    }

    public static void toFileNode(IdentityManager identityManager, Identity aclIdentity, Node node, FileNode fileNode, SpaceService spaceService) {
        try {
            fileNode.setDatasource(JCR_DATASOURCE_NAME);
            fileNode.setCloudDriveFile(node.hasProperty("ecd:driveUUID"));
            JCRDocumentsUtil.retrieveFileProperties(identityManager, node, aclIdentity, (AbstractNode)fileNode, spaceService);
            if (node.isNodeType("exo:symlink")) {
                JCRDocumentsUtil.retrieveSymlinkSize(node, fileNode);
            }
            JCRDocumentsUtil.retrieveViewsProperty(node, fileNode);
            if (node.hasNode("jcr:content")) {
                Node content = node.getNode("jcr:content");
                JCRDocumentsUtil.retrieveFileContentProperties(content, fileNode);
            }
        }
        catch (Exception e) {
            try {
                LOG.warn("Error computing File Node for search result with path {}", new Object[]{node.getPath(), e});
            }
            catch (Exception e1) {
                LOG.warn("Error computing File Node for search result with path {}", new Object[]{node, e});
            }
        }
    }

    private static void retrieveViewsProperty(Node node, FileNode fileNode) throws RepositoryException {
        long views = 0L;
        if (node.isNodeType("exo:symlink")) {
            node = JCRDocumentsUtil.getNodeByIdentifier(node.getSession(), fileNode.getSourceID());
        }
        if (node != null && node.hasProperty("exo:documentViews")) {
            views = node.getProperty("exo:documentViews").getLong();
        }
        fileNode.setViews(views);
    }

    private static void retrieveSymlinkSize(Node node, FileNode fileNode) throws RepositoryException {
        Node content;
        Node source = JCRDocumentsUtil.getNodeByIdentifier(node.getSession(), fileNode.getSourceID());
        if (source != null && source.getNode("jcr:content") != null && (content = source.getNode("jcr:content")).hasProperty("jcr:data")) {
            fileNode.setSize(content.getProperty("jcr:data").getLength());
        }
    }

    public static Node getNode(Session session, FileNode fileNode, DocumentFileSearchResult fileSearchResult) throws RepositoryException {
        Node node = JCRDocumentsUtil.getNodeByIdentifier(session, fileSearchResult.getId());
        if (node == null) {
            node = JCRDocumentsUtil.getNodeByPath(session, fileSearchResult.getNodePath());
        }
        if (node == null) {
            return null;
        }
        if (node.isNodeType("nt:frozenNode")) {
            String originalNodeId = node.getProperty("jcr:frozenUuid").getString();
            fileNode.setVersionnedFileId(originalNodeId);
        }
        if (node.hasProperty("exo:uuid")) {
            String targetNodeId = node.getProperty("exo:uuid").getString();
            fileNode.setLinkedFileId(targetNodeId);
            return JCRDocumentsUtil.getNodeById(session, targetNodeId);
        }
        return node;
    }

    public static void retrieveFileProperties(IdentityManager identityManager, Node node, Identity aclIdentity, AbstractNode documentNode, SpaceService spaceService) throws RepositoryException {
        block18: {
            Node sourceNode;
            documentNode.setId(((NodeImpl)node).getIdentifier());
            documentNode.setPath(node.getPath());
            try {
                Node parent = node.getParent();
                if (parent != null) {
                    documentNode.setParentFolderId(((NodeImpl)parent).getIdentifier());
                }
            }
            catch (RepositoryException parent) {
                // empty catch block
            }
            Node versionNode = node;
            if (node.isNodeType("exo:symlink") && (sourceNode = JCRDocumentsUtil.getNodeByIdentifier(node.getSession(), documentNode.getSourceID())) != null) {
                versionNode = sourceNode;
            }
            if (versionNode.isNodeType("mix:versionable") && versionNode.getBaseVersion() != null) {
                documentNode.setVersionable(true);
                Version version = versionNode.getBaseVersion();
                if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)version.getName())) {
                    documentNode.setVersionNumber(version.getName());
                }
            }
            if (node.hasProperty("exo:title")) {
                documentNode.setName(node.getProperty("exo:title").getString());
            } else {
                documentNode.setName(node.getName());
            }
            if (node.hasProperty("exo:dateCreated")) {
                long createdDate = node.getProperty("exo:dateCreated").getDate().getTimeInMillis();
                documentNode.setCreatedDate(createdDate);
            }
            if (node.hasProperty("exo:owner")) {
                String owner = node.getProperty("exo:owner").getString();
                documentNode.setCreatorId(JCRDocumentsUtil.getUserIdentityId(identityManager, owner));
            }
            if (node.hasProperty("exo:dateModified")) {
                Node nodeToModify = node;
                if (node.isNodeType("exo:symlink")) {
                    String sourceNodeId;
                    ManageableRepository repository;
                    RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
                    SessionProvider sessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = sessionProvider.getSession((repository = repositoryService.getCurrentRepository()).getConfiguration().getDefaultWorkspaceName(), repository);
                    Node sourceNode2 = JCRDocumentsUtil.getNodeByIdentifier(systemSession, sourceNodeId = node.getProperty("exo:uuid").getString());
                    if (sourceNode2 != null && sourceNode2.getProperty("exo:dateModified").getDate().compareTo(node.getProperty("exo:dateModified").getDate()) > 0) {
                        nodeToModify = sourceNode2;
                    }
                }
                long modifiedDate = nodeToModify.getProperty("exo:dateModified").getDate().getTimeInMillis();
                documentNode.setModifiedDate(modifiedDate);
                String modifier = nodeToModify.getProperty("exo:lastModifier").getString();
                documentNode.setModifierId(JCRDocumentsUtil.getUserIdentityId(identityManager, modifier));
            } else {
                documentNode.setModifiedDate(documentNode.getCreatedDate());
                documentNode.setModifierId(documentNode.getCreatorId());
            }
            if (node.hasProperty("dc:description")) {
                try {
                    documentNode.setDescription(node.getProperty("dc:description").getString());
                }
                catch (ValueFormatException e) {
                    Value[] descriptionValues = node.getProperty("dc:description").getValues();
                    if (descriptionValues == null || descriptionValues.length <= 0) break block18;
                    documentNode.setDescription(descriptionValues[0].getString());
                }
            }
        }
        if (node.isNodeType("dc:description")) {
            documentNode.setDescription(node.getProperty("dc:description").getString());
        }
        JCRDocumentsUtil.computeDocumentAcl(node, documentNode, aclIdentity, identityManager, spaceService);
    }

    public static void retrieveFileContentProperties(Node content, FileNode fileNode) throws RepositoryException {
        if (content.hasProperty("dc:description") && content.getProperty("dc:description").getValues().length > 0) {
            fileNode.setDescription(content.getProperty("dc:description").getValues()[0].getString());
        }
        if (content.hasProperty("jcr:mimeType")) {
            fileNode.setMimeType(content.getProperty("jcr:mimeType").getString());
        }
        if (content.hasProperty("jcr:data")) {
            fileNode.setSize(content.getProperty("jcr:data").getLength());
        }
    }

    public static void computeDocumentAcl(Node node, AbstractNode documentNode, Identity aclIdentity, IdentityManager identityManager, SpaceService spaceService) throws RepositoryException {
        boolean canEdit = false;
        boolean canDelete = false;
        ArrayList<PermissionEntry> permissions = new ArrayList<PermissionEntry>();
        String userId = aclIdentity.getUserId();
        ExtendedNode extendedNode = (ExtendedNode)node;
        List permsList = extendedNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            String nodeAclIdentity = accessControlEntry.getIdentity();
            MembershipEntry membershipEntry = accessControlEntry.getMembershipEntry();
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) || org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) || membershipEntry != null && aclIdentity.isMemberOf(membershipEntry)) {
                canEdit = canEdit || accessControlEntry.getPermission().contains("set_property");
                boolean bl = canDelete = canDelete || accessControlEntry.getPermission().contains("remove");
            }
            if (membershipEntry != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)membershipEntry.getGroup())) {
                Space space = spaceService.getSpaceByGroupId(membershipEntry.getGroup());
                if (space != null) {
                    org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
                    if (identity == null) continue;
                    permissions.add(new PermissionEntry(identity, accessControlEntry.getPermission(), JCRDocumentsUtil.getPermissionRole(accessControlEntry.getMembershipEntry().getMembershipType())));
                    continue;
                }
                if (JCRDocumentsUtil.groupToIdentity(membershipEntry.getGroup()) == null) continue;
                UserACL userACL = (UserACL)CommonsUtils.getService(UserACL.class);
                if (membershipEntry.getGroup().equals(userACL.getAdminGroups()) && !aclIdentity.isMemberOf(membershipEntry)) continue;
                permissions.add(new PermissionEntry(JCRDocumentsUtil.groupToIdentity(membershipEntry.getGroup()), accessControlEntry.getPermission(), PermissionRole.ALL.name()));
                continue;
            }
            org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateUserIdentity(nodeAclIdentity);
            if (identity == null) continue;
            permissions.add(new PermissionEntry(identity, accessControlEntry.getPermission(), PermissionRole.ALL.name()));
        }
        documentNode.setAcl(new NodePermission(true, canEdit, canDelete, permissions, null, null, null));
    }

    private static String getPermissionRole(String membershipType) {
        if (membershipType.equals("manager") || membershipType.equals("redactor")) {
            return PermissionRole.MANAGERS_REDACTORS.name();
        }
        return PermissionRole.ALL.name();
    }

    public static Node getNodeByIdentifier(Session session, String nodeId) {
        try {
            return ((ExtendedSession)session).getNodeByIdentifier(nodeId);
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with identifier {} is not found. Ignore search result.", new Object[]{nodeId});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with identifier {}. Will attempt to retrieve it by path", new Object[]{nodeId, e});
        }
        return null;
    }

    public static Node getNodeById(Session session, String nodeId) {
        try {
            return session.getNodeByUUID(nodeId);
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with UUID {} is not found. Ignore search result.", new Object[]{nodeId});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with UUID {}. Will attempt to retrieve it by path", new Object[]{nodeId, e});
        }
        return null;
    }

    public static Node getNodeByPath(Session session, String nodePath) {
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nodePath) && session.itemExists(nodePath)) {
                return (Node)session.getItem(nodePath);
            }
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with path {} is not found. Ignore search result.", new Object[]{nodePath});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with path {}", new Object[]{nodePath, e});
        }
        return null;
    }

    public static Node getIdentityRootNode(SpaceService spaceService, NodeHierarchyCreator nodeHierarchyCreator, String username, org.exoplatform.social.core.identity.model.Identity ownerIdentity, SessionProvider sessionProvider) throws Exception {
        Node identityRootNode = null;
        if (ownerIdentity.isSpace()) {
            Space space = spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            Session session = sessionProvider.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
            identityRootNode = JCRDocumentsUtil.getGroupNode(nodeHierarchyCreator, session, space.getGroupId());
        } else if (ownerIdentity.isUser()) {
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            Node identityNode = nodeHierarchyCreator.getUserNode(systemSession, ownerIdentity.getRemoteId());
            Session session = sessionProvider.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
            if (username.equals(ownerIdentity.getRemoteId())) {
                String privatePathNode = identityNode.getPath() + "/Private";
                if (session.itemExists(privatePathNode)) {
                    identityRootNode = (Node)session.getItem(privatePathNode);
                }
            } else {
                String publicPathNode = identityNode.getPath() + "/Public";
                identityRootNode = (Node)session.getItem(publicPathNode);
            }
        }
        return identityRootNode;
    }

    public static Node getIdentityRootNode(SpaceService spaceService, NodeHierarchyCreator nodeHierarchyCreator, org.exoplatform.social.core.identity.model.Identity ownerIdentity, Session session) throws Exception {
        SessionProvider systemSession;
        Node identityNode;
        String privatePathNode;
        Node identityRootNode = null;
        if (ownerIdentity.isSpace()) {
            Space space = spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            identityRootNode = JCRDocumentsUtil.getGroupNode(nodeHierarchyCreator, session, space.getGroupId());
        } else if (ownerIdentity.isUser() && session.itemExists(privatePathNode = (identityNode = nodeHierarchyCreator.getUserNode(systemSession = SessionProvider.createSystemProvider(), ownerIdentity.getRemoteId())).getPath() + "/Private")) {
            identityRootNode = (Node)session.getItem(privatePathNode);
        }
        return identityRootNode;
    }

    public static String getSortDirection(DocumentNodeFilter filter) {
        return filter.isAscending() ? "ASC" : "DESC";
    }

    public static String getSortField(DocumentNodeFilter filter, boolean isJcr) {
        DocumentSortField sortField = filter.getSortField();
        if (isJcr) {
            return SORT_FIELDS_JCR_CORRESPONDING.get(sortField);
        }
        return SORT_FIELDS_ES_CORRESPONDING.get(sortField);
    }

    public static SessionProvider getUserSessionProvider(RepositoryService repositoryService, Identity aclIdentity) {
        SessionProvider sessionProvider = new SessionProvider(new ConversationState(aclIdentity));
        try {
            ManageableRepository repository = repositoryService.getCurrentRepository();
            String workspace = repository.getConfiguration().getDefaultWorkspaceName();
            sessionProvider.setCurrentRepository(repository);
            sessionProvider.setCurrentWorkspace(workspace);
            return sessionProvider;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Can't build a SessionProvider", e);
        }
    }

    public static long getUserIdentityId(IdentityManager identityManager, String username) {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.ANONIM, (CharSequence)username) || org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.SYSTEM, (CharSequence)username) || org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)username)) {
            return 0L;
        }
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateUserIdentity(username);
        if (identity != null) {
            return Long.parseLong(identity.getId());
        }
        return 0L;
    }

    public static String cleanName(String oldName) {
        return JCRDocumentsUtil.cleanName(oldName, "nt:file");
    }

    public static String cleanName(String oldName, String nodeType) {
        if (StringUtils.isEmpty((String)oldName)) {
            return oldName;
        }
        String extension = "";
        if (nodeType.equals("nt:file") && oldName.lastIndexOf(".") > -1) {
            extension = oldName.substring(oldName.lastIndexOf("."));
            oldName = oldName.substring(0, oldName.lastIndexOf("."));
        }
        oldName = oldName.trim();
        String specialChar = "&#*@.'\"\t\r\n$\\><:;[]/|\u2019";
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < oldName.length(); ++i) {
            char currentChar = oldName.charAt(i);
            if (specialChar.indexOf(currentChar) > -1) {
                ret.append('_');
                continue;
            }
            ret.append(currentChar);
        }
        ret.append(extension);
        return ret.toString();
    }

    public static String cleanNameWithAccents(String fileName, String nodeType) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        if ("nt:file".equals(nodeType) && fileName.indexOf(46) > 0) {
            String ext = fileName.substring(fileName.lastIndexOf(46));
            fileName = accentsconverter.transliterate(fileName.substring(0, fileName.lastIndexOf(46))).concat(ext);
        } else {
            fileName = accentsconverter.transliterate(fileName);
        }
        return Text.escapeIllegalJcrChars((String)fileName);
    }

    public static boolean isValidDocumentTitle(String name) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)FilenameUtils.getBaseName((String)name))) {
            return false;
        }
        Pattern regex = Pattern.compile("[<\\\\>:\"/|?*]");
        Matcher matcher = regex.matcher(name);
        return !matcher.find();
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static org.exoplatform.social.core.identity.model.Identity getOwnerIdentityFromNodePath(String path, IdentityManager identityManager, SpaceService spaceService) {
        org.exoplatform.social.core.identity.model.Identity identity = null;
        if (path.contains(SPACE_PATH_PREFIX)) {
            String[] pathParts = path.split(SPACE_PATH_PREFIX)[1].split("/");
            String groupId = "/spaces/" + pathParts[0];
            Space space = spaceService.getSpaceByGroupId(groupId);
            if (space != null) {
                identity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            }
        } else if (path.contains(USER_PRIVATE_ROOT_NODE)) {
            String[] pathParts = path.split(USER_PRIVATE_ROOT_NODE)[0].split("/");
            String userName = pathParts[pathParts.length - 1];
            identity = identityManager.getOrCreateUserIdentity(userName);
        } else if (path.contains(USER_PUBLIC_ROOT_NODE)) {
            String[] pathParts = path.split(USER_PUBLIC_ROOT_NODE)[0].split("/");
            String userName = pathParts[pathParts.length - 1];
            identity = identityManager.getOrCreateUserIdentity(userName);
        }
        return identity;
    }

    public static FileVersion toFileVersion(Version version, Node node, IdentityManager identityManager) throws RepositoryException {
        FileVersion versionFileNode = new FileVersion();
        String currentVersionName = node.getBaseVersion().getName();
        Node frozen = version.getNode("jcr:frozenNode");
        if (node.hasProperty("exo:title")) {
            versionFileNode.setTitle(Utils.getStringProperty(node, "exo:title"));
        } else {
            versionFileNode.setTitle(node.getName());
        }
        String userName = frozen.getProperty("exo:lastModifier").getValue().getString();
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateIdentity("organization", userName);
        Profile profile = identity != null ? identity.getProfile() : null;
        String[] summary = node.getVersionHistory().getVersionLabels(version);
        if (summary.length > 0) {
            versionFileNode.setSummary(summary[0]);
        }
        versionFileNode.setId(version.getUUID());
        versionFileNode.setFrozenId(frozen.getUUID());
        versionFileNode.setOriginId(node.getUUID());
        versionFileNode.setAuthor(userName);
        versionFileNode.setAuthorFullName(profile != null ? profile.getFullName() : userName);
        versionFileNode.setCreatedDate(version.getCreated().getTime());
        versionFileNode.setVersionNumber(Integer.parseInt(version.getName()));
        if (version.getName().equals(currentVersionName)) {
            versionFileNode.setCurrent(true);
        }
        return versionFileNode;
    }

    public static String increaseNameIndex(String origin, int count) {
        int index = origin.indexOf(46);
        if (index == -1) {
            return origin + "(" + count + ")";
        }
        return origin.substring(0, index) + "(" + count + ")" + origin.substring(index);
    }

    public static String getNewIndexedName(String exoTitle, String newNameSuffix) {
        int pointIndex = exoTitle.lastIndexOf(".");
        String extension = pointIndex != -1 ? exoTitle.substring(pointIndex) : "";
        exoTitle = pointIndex != -1 ? exoTitle.substring(0, pointIndex).concat(newNameSuffix).concat(extension) : exoTitle.concat(newNameSuffix);
        return exoTitle;
    }

    public static boolean isFolder(Node node) throws RepositoryException {
        return node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured");
    }

    public static boolean hasEditPermission(Session session, Node node) {
        try {
            session.checkPermission(node.getPath(), "set_property");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static org.exoplatform.social.core.identity.model.Identity groupToIdentity(String groupId) {
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        try {
            Group group = organizationService.getGroupHandler().findGroupById(groupId);
            org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity();
            Profile profile = new Profile();
            profile.setProperty("fullName", (Object)group.getLabel());
            identity.setId("group:" + group.getGroupName());
            identity.setRemoteId(groupId);
            identity.setProviderId("group");
            identity.setProfile(profile);
            return identity;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DownloadItem toDownloadItem(Node node) throws Exception {
        Node content;
        ByteArrayOutputStream byteArrayOutputStream = null;
        String mimeType = null;
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")) != null && content.hasProperty("jcr:data")) {
            InputStream inputStream = content.getProperty("jcr:data").getStream();
            byteArrayOutputStream = JCRDocumentsUtil.write(inputStream);
            mimeType = Utils.getStringProperty(content, "jcr:mimeType");
        }
        return new DownloadItem(((NodeImpl)node).getIdentifier(), Utils.getStringProperty(node, "exo:title"), byteArrayOutputStream, mimeType);
    }

    private static ByteArrayOutputStream write(InputStream is) throws Exception {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream;
    }

    public static void createFile(Node node, String symlinkPath, String sourcePath, String tempFolderPath, String parentPath) throws RepositoryException, IOException {
        if (node == null) {
            return;
        }
        Node jrcNode = node.getNode("jcr:content");
        InputStream inputStream = jrcNode.getProperty("jcr:data").getStream();
        Object path = "";
        Object nodePath = node.getPath();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)symlinkPath) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sourcePath)) {
            nodePath = symlinkPath + ((String)nodePath).replace(sourcePath, "");
        }
        path = tempFolderPath + ((String)nodePath).replace(parentPath, "");
        File file = new File((String)path);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, length);
            }
            inputStream.close();
        }
    }

    public static void createTempFilesAndFolders(Node node, String symlinkPath, String sourcePath, String tempFolderPath, String parentPath) throws Exception {
        if (node == null) {
            return;
        }
        if (JCRDocumentsUtil.isFolder(node)) {
            Object nodePath = node.getPath();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)symlinkPath) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sourcePath)) {
                nodePath = symlinkPath + ((String)nodePath).replace(sourcePath, "");
            }
            String path = tempFolderPath + ((String)nodePath).replace(parentPath, "");
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                JCRDocumentsUtil.createTempFilesAndFolders(child, symlinkPath, sourcePath, tempFolderPath, parentPath);
            }
        } else if (node.isNodeType("exo:symlink")) {
            String sourceID = node.getProperty("exo:uuid").getString();
            Node sourceNode = JCRDocumentsUtil.getNodeByIdentifier(node.getSession(), sourceID);
            if (sourceNode != null) {
                JCRDocumentsUtil.createTempFilesAndFolders(sourceNode, node.getPath(), sourceNode.getPath(), tempFolderPath, parentPath);
            }
        } else {
            JCRDocumentsUtil.createFile(node, symlinkPath, sourcePath, tempFolderPath, parentPath);
        }
    }

    public static void cleanFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                JCRDocumentsUtil.cleanFiles(f);
            }
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            LOG.warn("Cannot delete {}", new Object[]{file.toPath(), e});
        }
    }

    public static void zipFiles(String zipFilePath, String tempFolderPath) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            File folder = new File(tempFolderPath);
            JCRDocumentsUtil.zipFolder(folder, "", zos);
        }
    }

    private static String getFolderName(File file, String folderName) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)folderName) ? folderName + "/" + file.getName() : file.getName();
    }

    private static void zipFolder(File folder, String folderName, ZipOutputStream zipOutputStream) throws Exception {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                JCRDocumentsUtil.zipFolder(file, JCRDocumentsUtil.getFolderName(file, folderName), zipOutputStream);
                continue;
            }
            byte[] buffer = new byte[1024];
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                zipOutputStream.putNextEntry(new ZipEntry(JCRDocumentsUtil.getFolderName(file, folderName)));
                while ((length = fis.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, length);
                }
                zipOutputStream.closeEntry();
            }
        }
    }

    public static String getFolderLink(Node node, Space space) throws RepositoryException {
        StringBuilder stringBuilder = new StringBuilder();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String domain = CommonsUtils.getCurrentDomain();
        stringBuilder.append(domain).append("/").append(LinkProvider.getPortalName(null)).append("/");
        if (space != null) {
            String groupId = space.getGroupId().replace("/", ":");
            stringBuilder.append("g/").append(groupId).append("/").append(space.getPrettyName()).append("/documents");
        } else {
            stringBuilder.append(portalOwner).append("/documents");
        }
        stringBuilder.append("?folderId=");
        stringBuilder.append(((NodeImpl)node).getIdentifier());
        return stringBuilder.toString();
    }

    static {
        SORT_FIELDS_JCR_CORRESPONDING.put(DocumentSortField.NAME, "exo:title");
        SORT_FIELDS_JCR_CORRESPONDING.put(DocumentSortField.CREATED_DATE, "exo:dateCreated");
        SORT_FIELDS_JCR_CORRESPONDING.put(DocumentSortField.MODIFIED_DATE, "exo:dateModified");
        SORT_FIELDS_ES_CORRESPONDING.put(DocumentSortField.NAME, "title");
        SORT_FIELDS_ES_CORRESPONDING.put(DocumentSortField.CREATED_DATE, "createdDate");
        SORT_FIELDS_ES_CORRESPONDING.put(DocumentSortField.MODIFIED_DATE, "lastUpdatedDate");
        groupsPath = null;
    }
}

