/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;

public class PortalURLBuilder
extends URLBuilder<UIComponent> {
    private final ComponentURL url;

    public PortalURLBuilder(PortalRequestContext ctx, ComponentURL url) {
        String path = ctx.getNodePath();
        url.setPath(path);
        this.url = url;
    }

    public String createAjaxURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params, boolean csrfCheck) {
        return this.createURL(true, targetComponent, action, confirm, targetBeanId, params, csrfCheck);
    }

    public String createURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params, boolean csrfCheck) {
        return this.createURL(false, targetComponent, action, confirm, targetBeanId, params, csrfCheck);
    }

    private String createURL(boolean ajax, UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params, boolean csrfCheck) {
        this.url.reset();
        this.url.setAjax(Boolean.valueOf(ajax));
        this.url.setConfirm(confirm);
        this.url.setResource(targetComponent);
        this.url.setAction(action);
        this.url.setQueryParameterValue("objectId", targetBeanId);
        if (params != null) {
            for (Parameter param : params) {
                this.url.setQueryParameterValue(param.getName(), param.getValue());
            }
        }
        if (this.removeLocale) {
            this.url.setLocale(null);
        } else if (this.locale != null) {
            this.url.setLocale(this.locale);
        }
        this.url.setCSRFCheck(csrfCheck);
        return this.url.toString();
    }
}

