/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE, name="ClosePopup")})
public class UIPageNavigationForm
extends UIForm {
    private UserNavigation userNav;
    private String ownerId;
    private String ownerType;
    private String priority;

    public void addFormInput() {
        ArrayList<SelectItemOption> priorties = new ArrayList<SelectItemOption>();
        int priority = Integer.parseInt(this.getPriority());
        if (priority == -1) {
            ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
            String undefined = resourceBundle.getString("UIPageNavigationForm.priority.undefined");
            priorties.add(new SelectItemOption(undefined, (Object)this.getPriority()));
        }
        for (int i = 1; i < 11; ++i) {
            priorties.add(new SelectItemOption(String.valueOf(i), (Object)String.valueOf(i)));
        }
        if (priority > 10) {
            priorties.add(new SelectItemOption(this.getPriority(), (Object)this.getPriority()));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput("ownerType", "ownerType", this.getOwnerType()).setReadOnly(true)).addUIFormInput((UIFormInput)new UIFormStringInput("ownerId", "ownerId", this.ownerId).setReadOnly(true)).addUIFormInput((UIFormInput)new UIFormSelectBox("priority", null, priorties).setValue(this.getPriority()));
    }

    public void setValues(UserNavigation userNavigation) throws Exception {
        this.setUserNav(userNavigation);
        this.invokeGetBindingBean(userNavigation);
        this.removeChildById("ownerId");
        UIFormStringInput ownerId = new UIFormStringInput("ownerId", "ownerId", userNavigation.getKey().getName());
        ownerId.setReadOnly(true);
        ownerId.setParent((UIComponent)this);
        this.getChildren().add(1, ownerId);
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById("priority");
        uiSelectBox.setValue(String.valueOf(userNavigation.getPriority()));
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setUserNav(UserNavigation pageNav_) {
        this.userNav = pageNav_;
    }

    public UserNavigation getUserNav() {
        return this.userNav;
    }

    public static class CloseActionListener
    extends EventListener<UIPageNavigationForm> {
        public void execute(Event<UIPageNavigationForm> event) throws Exception {
            UIPageNavigationForm uiForm = (UIPageNavigationForm)((Object)event.getSource());
            uiForm.getParent().broadcast(event, Event.Phase.ANY);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIPageNavigationForm> {
        public void execute(Event<UIPageNavigationForm> event) throws Exception {
            UIPageNavigationForm uiForm = (UIPageNavigationForm)((Object)event.getSource());
            UserNavigation userNav = uiForm.getUserNav();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UserPortal userPortal = prContext.getUserPortalConfig().getUserPortal();
            userNav = userPortal.getNavigation(userNav.getKey());
            if (userNav == null) {
                UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                uiPortalApp.addMessage(new ApplicationMessage("UINavigationManagement.msg.NavigationNotExistAnymore", null));
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                prContext.setFullRender(true);
                UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
                uiPopup.setShow(false);
                return;
            }
            UIFormSelectBox uiSelectBox = (UIFormSelectBox)uiForm.findComponentById("priority");
            int priority = Integer.parseInt((String)uiSelectBox.getValue());
            NavigationService service = (NavigationService)uiForm.getApplicationComponent(NavigationService.class);
            NavigationContext ctx = service.loadNavigation(userNav.getKey());
            ctx.setState(new NavigationState(Integer.valueOf(priority)));
            service.saveNavigation(ctx);
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setShow(false);
            UIComponent opener = uiPopup.getParent();
            ActionResponse response = (ActionResponse)event.getRequestContext().getResponse();
            response.setEvent(new QName("NavigationChange"), null);
            WebuiRequestContext pcontext = event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax(opener);
        }
    }
}

