/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class ParserUtils {
    public static String removeChars(String s, char occur) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == occur) continue;
            newString.append(ch);
        }
        return newString.toString();
    }

    public static String removeEscapeCharacters(String inputString) {
        inputString = ParserUtils.removeChars(inputString, '\r');
        inputString = ParserUtils.removeChars(inputString, '\n');
        inputString = ParserUtils.removeChars(inputString, '\t');
        return inputString;
    }

    public static String removeTrailingBlanks(String text) {
        int ch = 32;
        while (ch == 32) {
            ch = text.charAt(text.length() - 1);
            if (ch != 32) continue;
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static Node[] findTypeInNode(Node node, Class type) {
        NodeList ret = new NodeList();
        NodeClassFilter filter = new NodeClassFilter(type);
        node.collectInto(ret, (NodeFilter)filter);
        return ret.toNodeArray();
    }

    public static String[] splitButDigits(String input, String charsDoNotBeRemoved) {
        ArrayList<String> output = new ArrayList<String>();
        int minCapacity = 0;
        StringBuffer str = new StringBuffer();
        boolean charFound = false;
        boolean toBeAdd = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (Character.isDigit(input.charAt(index)) || charFound) {
                str.append(input.charAt(index));
                toBeAdd = false;
            } else if (!toBeAdd) {
                toBeAdd = true;
            }
            if (!toBeAdd || str.length() == 0) continue;
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
                continue;
            }
            --minCapacity;
        }
        if (str.length() != 0) {
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
            } else {
                --minCapacity;
            }
        }
        output.trimToSize();
        Object[] outputObj = output.toArray();
        String[] outputStr = new String[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            outputStr[i] = new String((String)outputObj[i]);
        }
        return outputStr;
    }

    public static String trimButDigits(String input, String charsDoNotBeRemoved) {
        StringBuffer output = new StringBuffer();
        boolean charFound = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!Character.isDigit(input.charAt(index)) && !charFound) continue;
            output.append(input.charAt(index));
        }
        return output.toString();
    }

    public static String trimButDigitsBeginEnd(String input, String charsDoNotBeRemoved) {
        int charsCount;
        int index;
        String output = new String();
        int begin = 0;
        int end = input.length() - 1;
        boolean charFound = false;
        boolean ok = true;
        for (index = begin; index < input.length() && ok; ++index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!Character.isDigit(input.charAt(index)) && !charFound) continue;
            begin = index;
            ok = false;
        }
        ok = true;
        for (index = end; index >= 0 && ok; --index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!Character.isDigit(input.charAt(index)) && !charFound) continue;
            end = index;
            ok = false;
        }
        output = input.substring(begin, end + 1);
        return output;
    }

    public static String[] splitSpaces(String input, String charsToBeRemoved) {
        ArrayList<String> output = new ArrayList<String>();
        int minCapacity = 0;
        StringBuffer str = new StringBuffer();
        boolean charFound = false;
        boolean toBeAdd = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!(Character.isWhitespace(input.charAt(index)) || Character.isSpaceChar(input.charAt(index)) || charFound)) {
                str.append(input.charAt(index));
                toBeAdd = false;
            } else if (!toBeAdd) {
                toBeAdd = true;
            }
            if (!toBeAdd || str.length() == 0) continue;
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
                continue;
            }
            --minCapacity;
        }
        if (str.length() != 0) {
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
            } else {
                --minCapacity;
            }
        }
        output.trimToSize();
        Object[] outputObj = output.toArray();
        String[] outputStr = new String[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            outputStr[i] = new String((String)outputObj[i]);
        }
        return outputStr;
    }

    public static String trimSpaces(String input, String charsToBeRemoved) {
        StringBuffer output = new StringBuffer();
        boolean charFound = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (Character.isWhitespace(input.charAt(index)) || Character.isSpaceChar(input.charAt(index)) || charFound) continue;
            output.append(input.charAt(index));
        }
        return output.toString();
    }

    public static String trimSpacesBeginEnd(String input, String charsToBeRemoved) {
        int charsCount;
        int index;
        String output = new String();
        int begin = 0;
        int end = input.length() - 1;
        boolean charFound = false;
        boolean ok = true;
        for (index = begin; index < input.length() && ok; ++index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (Character.isWhitespace(input.charAt(index)) || Character.isSpaceChar(input.charAt(index)) || charFound) continue;
            begin = index;
            ok = false;
        }
        ok = true;
        for (index = end; index >= 0 && ok; --index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (Character.isWhitespace(input.charAt(index)) || Character.isSpaceChar(input.charAt(index)) || charFound) continue;
            end = index;
            ok = false;
        }
        output = input.substring(begin, end + 1);
        return output;
    }

    public static String[] splitButChars(String input, String charsDoNotBeRemoved) {
        ArrayList<String> output = new ArrayList<String>();
        int minCapacity = 0;
        StringBuffer str = new StringBuffer();
        boolean charFound = false;
        boolean toBeAdd = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (charFound) {
                str.append(input.charAt(index));
                toBeAdd = false;
            } else if (!toBeAdd) {
                toBeAdd = true;
            }
            if (!toBeAdd || str.length() == 0) continue;
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
                continue;
            }
            --minCapacity;
        }
        if (str.length() != 0) {
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
            } else {
                --minCapacity;
            }
        }
        output.trimToSize();
        Object[] outputObj = output.toArray();
        String[] outputStr = new String[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            outputStr[i] = new String((String)outputObj[i]);
        }
        return outputStr;
    }

    public static String trimButChars(String input, String charsDoNotBeRemoved) {
        StringBuffer output = new StringBuffer();
        boolean charFound = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!charFound) continue;
            output.append(input.charAt(index));
        }
        return output.toString();
    }

    public static String trimButCharsBeginEnd(String input, String charsDoNotBeRemoved) {
        int charsCount;
        int index;
        String output = new String();
        int begin = 0;
        int end = input.length() - 1;
        boolean charFound = false;
        boolean ok = true;
        for (index = begin; index < input.length() && ok; ++index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!charFound) continue;
            begin = index;
            ok = false;
        }
        ok = true;
        for (index = end; index >= 0 && ok; --index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsDoNotBeRemoved.length(); ++charsCount) {
                if (charsDoNotBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!charFound) continue;
            end = index;
            ok = false;
        }
        output = input.substring(begin, end + 1);
        return output;
    }

    public static String[] splitChars(String input, String charsToBeRemoved) {
        ArrayList<String> output = new ArrayList<String>();
        int minCapacity = 0;
        StringBuffer str = new StringBuffer();
        boolean charFound = false;
        boolean toBeAdd = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (!charFound) {
                str.append(input.charAt(index));
                toBeAdd = false;
            } else if (!toBeAdd) {
                toBeAdd = true;
            }
            if (!toBeAdd || str.length() == 0) continue;
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
                continue;
            }
            --minCapacity;
        }
        if (str.length() != 0) {
            output.ensureCapacity(++minCapacity);
            if (output.add(str.toString())) {
                str = new StringBuffer();
            } else {
                --minCapacity;
            }
        }
        output.trimToSize();
        Object[] outputObj = output.toArray();
        String[] outputStr = new String[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            outputStr[i] = new String((String)outputObj[i]);
        }
        return outputStr;
    }

    public static String trimChars(String input, String charsToBeRemoved) {
        StringBuffer output = new StringBuffer();
        boolean charFound = false;
        for (int index = 0; index < input.length(); ++index) {
            charFound = false;
            for (int charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (charFound) continue;
            output.append(input.charAt(index));
        }
        return output.toString();
    }

    public static String trimCharsBeginEnd(String input, String charsToBeRemoved) {
        int charsCount;
        int index;
        String output = new String();
        int begin = 0;
        int end = input.length() - 1;
        boolean charFound = false;
        boolean ok = true;
        for (index = begin; index < input.length() && ok; ++index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (charFound) continue;
            begin = index;
            ok = false;
        }
        ok = true;
        for (index = end; index >= 0 && ok; --index) {
            charFound = false;
            for (charsCount = 0; charsCount < charsToBeRemoved.length(); ++charsCount) {
                if (charsToBeRemoved.charAt(charsCount) != input.charAt(index)) continue;
                charFound = true;
            }
            if (charFound) continue;
            end = index;
            ok = false;
        }
        output = input.substring(begin, end + 1);
        return output;
    }

    public static String[] splitTags(String input, String[] tags) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.splitTags(input, tags, true, true);
    }

    public static String[] splitTags(String input, String[] tags, boolean recursive, boolean insideTag) throws ParserException, UnsupportedEncodingException {
        ArrayList<String> outputArrayList = new ArrayList<String>();
        int minCapacity = 0;
        String output = new String();
        String inputModified = new String(input);
        String[] outputStr = new String[]{};
        String dummyString = ParserUtils.createDummyString(' ', input.length());
        for (int i = 0; i < tags.length; ++i) {
            NodeList links = ParserUtils.getLinks(inputModified, tags[i], recursive);
            for (int j = 0; j < links.size(); ++j) {
                CompositeTag beginTag = (CompositeTag)links.elementAt(j);
                Tag endTag = beginTag.getEndTag();
                int beginTagBegin = beginTag.getStartPosition();
                int endTagBegin = beginTag.getEndPosition();
                int beginTagEnd = endTag.getStartPosition();
                int endTagEnd = endTag.getEndPosition();
                if (insideTag) {
                    dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagEnd);
                    continue;
                }
                dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagBegin);
                dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagEnd, endTagEnd);
            }
            int k = dummyString.indexOf(32);
            while (k < dummyString.length() && k != -1) {
                int kNew = dummyString.indexOf(42, k);
                if (kNew != -1) {
                    output = inputModified.substring(k, kNew);
                    k = dummyString.indexOf(32, kNew);
                    outputArrayList.ensureCapacity(++minCapacity);
                    if (outputArrayList.add(output)) {
                        output = new String();
                        continue;
                    }
                    --minCapacity;
                    continue;
                }
                output = inputModified.substring(k, dummyString.length());
                k = kNew;
                outputArrayList.ensureCapacity(++minCapacity);
                if (outputArrayList.add(output)) {
                    output = new String();
                    continue;
                }
                --minCapacity;
            }
            StringBuffer outputStringBuffer = new StringBuffer();
            outputArrayList.trimToSize();
            Object[] outputObj = outputArrayList.toArray();
            outputStr = new String[outputArrayList.size()];
            for (int j = 0; j < outputArrayList.size(); ++j) {
                outputStr[j] = new String((String)outputObj[j]);
                outputStringBuffer.append(outputStr[j]);
            }
            outputArrayList = new ArrayList();
            inputModified = new String(outputStringBuffer.toString());
            dummyString = ParserUtils.createDummyString(' ', inputModified.length());
        }
        return outputStr;
    }

    public static String[] splitTags(String input, Class nodeType) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.splitTags(input, new NodeClassFilter(nodeType), true, true);
    }

    public static String[] splitTags(String input, Class nodeType, boolean recursive, boolean insideTag) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.splitTags(input, new NodeClassFilter(nodeType), recursive, insideTag);
    }

    public static String[] splitTags(String input, NodeFilter filter) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.splitTags(input, filter, true, true);
    }

    public static String[] splitTags(String input, NodeFilter filter, boolean recursive, boolean insideTag) throws ParserException, UnsupportedEncodingException {
        ArrayList<String> outputArrayList = new ArrayList<String>();
        int minCapacity = 0;
        String output = new String();
        String dummyString = ParserUtils.createDummyString(' ', input.length());
        NodeList links = ParserUtils.getLinks(input, filter, recursive);
        for (int j = 0; j < links.size(); ++j) {
            CompositeTag beginTag = (CompositeTag)links.elementAt(j);
            Tag endTag = beginTag.getEndTag();
            int beginTagBegin = beginTag.getStartPosition();
            int endTagBegin = beginTag.getEndPosition();
            int beginTagEnd = endTag.getStartPosition();
            int endTagEnd = endTag.getEndPosition();
            if (insideTag) {
                dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagEnd);
                continue;
            }
            dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagBegin);
            dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagEnd, endTagEnd);
        }
        int k = dummyString.indexOf(32);
        while (k < dummyString.length() && k != -1) {
            int kNew = dummyString.indexOf(42, k);
            if (kNew != -1) {
                output = input.substring(k, kNew);
                k = dummyString.indexOf(32, kNew);
                outputArrayList.ensureCapacity(++minCapacity);
                if (outputArrayList.add(output)) {
                    output = new String();
                    continue;
                }
                --minCapacity;
                continue;
            }
            output = input.substring(k, dummyString.length());
            k = kNew;
            outputArrayList.ensureCapacity(++minCapacity);
            if (outputArrayList.add(output)) {
                output = new String();
                continue;
            }
            --minCapacity;
        }
        outputArrayList.trimToSize();
        Object[] outputObj = outputArrayList.toArray();
        String[] outputStr = new String[outputArrayList.size()];
        for (int i = 0; i < outputArrayList.size(); ++i) {
            outputStr[i] = new String((String)outputObj[i]);
        }
        return outputStr;
    }

    public static String trimAllTags(String input, boolean inside) {
        StringBuffer output = new StringBuffer();
        if (inside) {
            if (input.indexOf(60) == -1 || input.lastIndexOf(62) == -1 || input.lastIndexOf(62) < input.indexOf(60)) {
                output.append(input);
            } else {
                output.append(input.substring(0, input.indexOf(60)));
                output.append(input.substring(input.lastIndexOf(62) + 1, input.length()));
            }
        } else {
            boolean write = true;
            for (int index = 0; index < input.length(); ++index) {
                if (input.charAt(index) == '<' && write) {
                    write = false;
                }
                if (write) {
                    output.append(input.charAt(index));
                }
                if (input.charAt(index) != '>' || write) continue;
                write = true;
            }
        }
        return output.toString();
    }

    public static String trimTags(String input, String[] tags) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.trimTags(input, tags, true, true);
    }

    public static String trimTags(String input, String[] tags, boolean recursive, boolean insideTag) throws ParserException, UnsupportedEncodingException {
        StringBuffer output = new StringBuffer();
        String inputModified = new String(input);
        String dummyString = ParserUtils.createDummyString(' ', input.length());
        for (int i = 0; i < tags.length; ++i) {
            output = new StringBuffer();
            NodeList links = ParserUtils.getLinks(inputModified, tags[i], recursive);
            for (int j = 0; j < links.size(); ++j) {
                CompositeTag beginTag = (CompositeTag)links.elementAt(j);
                Tag endTag = beginTag.getEndTag();
                int beginTagBegin = beginTag.getStartPosition();
                int endTagBegin = beginTag.getEndPosition();
                int beginTagEnd = endTag.getStartPosition();
                int endTagEnd = endTag.getEndPosition();
                if (insideTag) {
                    dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagEnd);
                    continue;
                }
                dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagBegin);
                dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagEnd, endTagEnd);
            }
            int k = dummyString.indexOf(32);
            while (k < dummyString.length() && k != -1) {
                int kNew = dummyString.indexOf(42, k);
                if (kNew != -1) {
                    output = output.append(inputModified.substring(k, kNew));
                    k = dummyString.indexOf(32, kNew);
                    continue;
                }
                output = output.append(inputModified.substring(k, dummyString.length()));
                k = kNew;
            }
            inputModified = new String(output);
            dummyString = ParserUtils.createDummyString(' ', inputModified.length());
        }
        return output.toString();
    }

    public static String trimTags(String input, Class nodeType) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.trimTags(input, new NodeClassFilter(nodeType), true, true);
    }

    public static String trimTags(String input, Class nodeType, boolean recursive, boolean insideTag) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.trimTags(input, new NodeClassFilter(nodeType), recursive, insideTag);
    }

    public static String trimTags(String input, NodeFilter filter) throws ParserException, UnsupportedEncodingException {
        return ParserUtils.trimTags(input, filter, true, true);
    }

    public static String trimTags(String input, NodeFilter filter, boolean recursive, boolean insideTag) throws ParserException, UnsupportedEncodingException {
        StringBuffer output = new StringBuffer();
        String dummyString = ParserUtils.createDummyString(' ', input.length());
        NodeList links = ParserUtils.getLinks(input, filter, recursive);
        for (int j = 0; j < links.size(); ++j) {
            CompositeTag beginTag = (CompositeTag)links.elementAt(j);
            Tag endTag = beginTag.getEndTag();
            int beginTagBegin = beginTag.getStartPosition();
            int endTagBegin = beginTag.getEndPosition();
            int beginTagEnd = endTag.getStartPosition();
            int endTagEnd = endTag.getEndPosition();
            if (insideTag) {
                dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagEnd);
                continue;
            }
            dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagBegin, endTagBegin);
            dummyString = ParserUtils.modifyDummyString(new String(dummyString), beginTagEnd, endTagEnd);
        }
        int k = dummyString.indexOf(32);
        while (k < dummyString.length() && k != -1) {
            int kNew = dummyString.indexOf(42, k);
            if (kNew != -1) {
                output = output.append(input.substring(k, kNew));
                k = dummyString.indexOf(32, kNew);
                continue;
            }
            output = output.append(input.substring(k, dummyString.length()));
            k = kNew;
        }
        return output.toString();
    }

    public static Parser createParserParsingAnInputString(String input) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(input);
        lexer.setPage(page);
        parser.setLexer(lexer);
        return parser;
    }

    private static NodeList getLinks(String output, String tag, boolean recursive) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        TagNameFilter filterLink = new TagNameFilter(tag);
        NodeList links = new NodeList();
        parser = ParserUtils.createParserParsingAnInputString(output);
        links = parser.extractAllNodesThatMatch(filterLink);
        if (!recursive) {
            for (int j = 0; j < links.size(); ++j) {
                CompositeTag jStartTag = (CompositeTag)links.elementAt(j);
                Tag jEndTag = jStartTag.getEndTag();
                int jStartTagBegin = jStartTag.getStartPosition();
                int jEndTagEnd = jEndTag.getEndPosition();
                for (int k = 0; k < links.size(); ++k) {
                    CompositeTag kStartTag = (CompositeTag)links.elementAt(k);
                    Tag kEndTag = kStartTag.getEndTag();
                    int kStartTagBegin = kStartTag.getStartPosition();
                    int kEndTagEnd = kEndTag.getEndPosition();
                    if (k == j || kStartTagBegin <= jStartTagBegin || kEndTagEnd >= jEndTagEnd) continue;
                    links.remove(k);
                    --k;
                    --j;
                }
            }
        }
        return links;
    }

    private static NodeList getLinks(String output, NodeFilter filter, boolean recursive) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        NodeList links = new NodeList();
        parser = ParserUtils.createParserParsingAnInputString(output);
        links = parser.extractAllNodesThatMatch(filter);
        if (!recursive) {
            for (int j = 0; j < links.size(); ++j) {
                CompositeTag jStartTag = (CompositeTag)links.elementAt(j);
                Tag jEndTag = jStartTag.getEndTag();
                int jStartTagBegin = jStartTag.getStartPosition();
                int jEndTagEnd = jEndTag.getEndPosition();
                for (int k = 0; k < links.size(); ++k) {
                    CompositeTag kStartTag = (CompositeTag)links.elementAt(k);
                    Tag kEndTag = kStartTag.getEndTag();
                    int kStartTagBegin = kStartTag.getStartPosition();
                    int kEndTagEnd = kEndTag.getEndPosition();
                    if (k == j || kStartTagBegin <= jStartTagBegin || kEndTagEnd >= jEndTagEnd) continue;
                    links.remove(k);
                    --k;
                    --j;
                }
            }
        }
        return links;
    }

    private static String createDummyString(char fillingChar, int length) {
        StringBuffer dummyStringBuffer = new StringBuffer();
        for (int j = 0; j < length; ++j) {
            dummyStringBuffer = dummyStringBuffer.append(fillingChar);
        }
        return new String(dummyStringBuffer);
    }

    private static String modifyDummyString(String dummyString, int beginTag, int endTag) {
        String dummyStringInterval = ParserUtils.createDummyString('*', endTag - beginTag);
        return new String(dummyString.substring(0, beginTag) + dummyStringInterval + dummyString.substring(endTag, dummyString.length()));
    }
}

