/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatTag;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class OSArrayTag
extends MatTag {
    private ByteBuffer data;

    public OSArrayTag(int type, byte[] data) {
        this(type, ByteBuffer.wrap(data));
    }

    public OSArrayTag(int type, ByteBuffer data) {
        super(type, data.limit());
        this.data = data;
        data.rewind();
    }

    public void writeTo(DataOutputStream os) throws IOException {
        int padding;
        if (this.size <= 4 && this.size > 0) {
            os.writeShort(this.size);
            os.writeShort(this.type);
            padding = this.getPadding(this.data.limit(), true);
        } else {
            os.writeInt(this.type);
            os.writeInt(this.size);
            padding = this.getPadding(this.data.limit(), false);
        }
        int maxBuffSize = 1024;
        int writeBuffSize = this.data.remaining() < maxBuffSize ? this.data.remaining() : maxBuffSize;
        byte[] tmp = new byte[writeBuffSize];
        while (this.data.remaining() > 0) {
            int length = this.data.remaining() > tmp.length ? tmp.length : this.data.remaining();
            this.data.get(tmp, 0, length);
            os.write(tmp, 0, length);
        }
        if (padding > 0) {
            os.write(new byte[padding]);
        }
    }
}

