/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.dao.EventAttendeeDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.entity.EventAttendeeEntity;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventAttendeeList;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.services.listener.ListenerService;

public class AgendaEventAttendeeStorage {
    private EventDAO eventDAO;
    private EventAttendeeDAO eventAttendeeDAO;
    private ListenerService listenerService;

    public AgendaEventAttendeeStorage(EventDAO eventDAO, EventAttendeeDAO eventAttendeeDAO, ListenerService listenerService) {
        this.eventDAO = eventDAO;
        this.eventAttendeeDAO = eventAttendeeDAO;
        this.listenerService = listenerService;
    }

    public void saveEventAttendee(EventAttendee eventAttendee, long eventId) {
        EventAttendeeEntity eventAttendeeEntity = EntityMapper.toEntity(eventAttendee);
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        eventAttendeeEntity.setEvent(eventEntity);
        long eventAttendeeId = eventAttendee.getId();
        if (eventAttendeeId > 0L) {
            this.eventAttendeeDAO.update(eventAttendeeEntity);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attendee.updated", eventAttendeeEntity.getEvent().getId(), eventAttendeeId);
        } else {
            eventAttendeeEntity.setId(null);
            eventAttendeeEntity = (EventAttendeeEntity)this.eventAttendeeDAO.create(eventAttendeeEntity);
            eventAttendeeId = eventAttendeeEntity.getId();
            eventAttendee.setId(eventAttendeeId);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attendee.created", eventAttendeeEntity.getEvent().getId(), eventAttendeeId);
        }
    }

    public EventAttendeeList getEventAttendees(long eventId) {
        List<EventAttendeeEntity> eventAttendeeEntities = this.eventAttendeeDAO.getEventAttendees(eventId);
        return this.fromAttendeeEntities(eventId, eventAttendeeEntities);
    }

    public EventAttendeeList getEventAttendees(long eventId, EventAttendeeResponse ... responses) {
        List<EventAttendeeEntity> eventAttendeeEntities = this.eventAttendeeDAO.getEventAttendeesByResponses(eventId, responses);
        return this.fromAttendeeEntities(eventId, eventAttendeeEntities);
    }

    public EventAttendeeList getEventAttendees(long eventId, long identityId) {
        List<EventAttendeeEntity> eventAttendeeEntities = this.eventAttendeeDAO.getEventAttendees(eventId, identityId);
        return this.fromAttendeeEntities(eventId, eventAttendeeEntities);
    }

    public void removeEventAttendee(long eventAttendeeId) {
        EventAttendeeEntity eventAttendeeEntity = (EventAttendeeEntity)this.eventAttendeeDAO.find(Long.valueOf(eventAttendeeId));
        if (eventAttendeeEntity != null) {
            this.eventAttendeeDAO.delete(eventAttendeeEntity);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attendee.deleted", eventAttendeeEntity.getEvent().getId(), eventAttendeeId);
        }
    }

    private EventAttendeeList fromAttendeeEntities(long eventId, List<EventAttendeeEntity> eventAttendeeEntities) {
        if (CollectionUtils.isEmpty(eventAttendeeEntities)) {
            return EventAttendeeList.EMPTY_ATTENDEE_LIST;
        }
        List attendees = eventAttendeeEntities.stream().map(eventAttendeeEntity -> EntityMapper.fromEntity(eventAttendeeEntity, eventId)).collect(Collectors.toList());
        return new EventAttendeeList(attendees);
    }
}

