/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;

@ComponentConfig(template="system:/groovy/webui/core/UITree.gtmpl")
public class UIPublicationTree
extends UITree {
    public String event(String name, String beanId) throws Exception {
        UIComponent component = this.getParent();
        return component.event(name, beanId);
    }

    public String getActionLink() throws Exception {
        if (this.getSelected() == null) {
            return "javascript:void(0)";
        }
        if (this.getParentSelected() == null) {
            return "javascript:void(0)";
        }
        return this.event("ChangeNode", (String)this.getId(this.getParentSelected()));
    }

    public boolean isSelected(Object obj) throws Exception {
        TreeNode selected = (TreeNode)this.getSelected();
        if (selected == null) {
            return false;
        }
        TreeNode compared = (TreeNode)TreeNode.class.cast(obj);
        return compared.getUri().equals(selected.getUri());
    }

    public static class TreeNode {
        private String portalName;
        private boolean isUserNode;
        private UserNode userNode;
        private UserNavigation navigation;
        private List<TreeNode> children;
        private ResourceBundle resourceBundle;

        public TreeNode(String portalName, UserNavigation navigation, ResourceBundle res, boolean isUserNode) {
            this.portalName = portalName;
            this.navigation = navigation;
            this.resourceBundle = res;
            this.isUserNode = isUserNode;
        }

        public String getUri() {
            if (this.isUserNode) {
                return "/" + this.portalName + "/" + this.userNode.getURI();
            }
            return "/" + this.portalName;
        }

        public String getPageNodeUri() {
            if (this.isUserNode) {
                return this.userNode.getURI();
            }
            return null;
        }

        public String getIcon() {
            if (!this.isUserNode) {
                return "";
            }
            return this.userNode.getIcon();
        }

        public List<TreeNode> getTreeNodeChildren() {
            return this.children;
        }

        public void setTreeNodeChildren(List<TreeNode> list) {
            this.children = list;
        }

        public void setUserNode(UserNode userNode) {
            this.userNode = userNode;
            if (userNode.getChildren() == null) {
                this.children = null;
            }
        }

        public boolean isPageNode() {
            return this.isUserNode;
        }

        public void setIsPageNode(boolean isPageNode) {
            this.isUserNode = isPageNode;
        }

        public String getName() {
            if (this.isUserNode) {
                return this.userNode.getName();
            }
            return this.portalName;
        }

        public String getResolvedLabel() {
            if (this.isUserNode) {
                return this.userNode.getEncodedResolvedLabel();
            }
            return this.portalName;
        }

        public void setPortalName(String s) {
            this.portalName = s;
        }

        public String getPortalName() {
            return this.portalName;
        }

        public void setChildrenByUserNodes(Collection<UserNode> userNodes) throws Exception {
            if (userNodes == null) {
                return;
            }
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
            for (UserNode pNode : userNodes) {
                PageContext page;
                if (pNode.getPageRef() == null || (page = userPortalConfigService.getPage(pNode.getPageRef())) == null) continue;
                TreeNode treeNode = new TreeNode(this.portalName, this.navigation, this.resourceBundle, true);
                treeNode.setUserNode(pNode);
                treeNode.setChildrenByUserNodes(pNode.getChildren());
                list.add(treeNode);
            }
            this.setTreeNodeChildren(list);
        }

        public TreeNode searchTreeNodeByURI(String uri) throws Exception {
            TreeNode treeNode = new TreeNode(this.portalName, this.navigation, this.resourceBundle, true);
            return treeNode;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public UserNavigation getNavigation() {
            return this.navigation;
        }

        public UserNode getUserNode() {
            return this.userNode;
        }
    }
}

