/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.job;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class TransactionSenderJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(TransactionSenderJob.class);
    protected ExoContainer container = PortalContainer.getInstance();
    protected BlockchainTransactionService blockchainTransactionService = (BlockchainTransactionService)this.container.getComponentInstanceOfType(BlockchainTransactionService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.blockchainTransactionService.sendPendingTransactionsToBlockchain();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while sending raw transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }
}

