/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.channel.template;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class TemplateProvider
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(TemplateProvider.class);
    public static final String CHANNEL_ID_KEY = "channel-id";
    protected final Map<PluginKey, String> templateFilePaths = new HashMap<PluginKey, String>();
    protected final Map<PluginKey, AbstractTemplateBuilder> templateBuilders = new HashMap<PluginKey, AbstractTemplateBuilder>();
    private ChannelKey key = null;

    public TemplateProvider(InitParams initParams) {
        TemplateConfigs templates = ((Object)((Object)this)).getClass().getAnnotation(TemplateConfigs.class);
        if (templates != null) {
            for (TemplateConfig config : templates.templates()) {
                if (config == null || config.pluginId().isEmpty()) continue;
                this.templateFilePaths.put(PluginKey.key(config.pluginId()), config.template());
            }
        }
        ValueParam channelIdParam = initParams.getValueParam(CHANNEL_ID_KEY);
        try {
            this.key = ChannelKey.key(channelIdParam.getValue());
        }
        catch (Exception e) {
            LOG.error((Object)"Register the template provider must allow the channelId.", (Throwable)e);
        }
    }

    private TemplateProvider() {
    }

    public Map<PluginKey, String> getTemplateFilePathConfigs() {
        return this.templateFilePaths;
    }

    public Map<PluginKey, AbstractTemplateBuilder> getTemplateBuilder() {
        return this.templateBuilders;
    }

    public ChannelKey getChannelKey() {
        return this.key;
    }
}

