/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.notification.plugin;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.chat.model.MessageReceivedModel;
import org.exoplatform.addons.chat.utils.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class ChatMessageNotificationPlugin
extends BaseNotificationPlugin {
    public ChatMessageNotificationPlugin(InitParams initParams) {
        super(initParams);
        ValueParam notificationIdParam = initParams.getValueParam("notification.id");
        if (notificationIdParam == null || StringUtils.isBlank((String)notificationIdParam.getValue())) {
            throw new IllegalStateException("'notification.id' parameter is mandatory");
        }
    }

    public String getId() {
        return "ChatMessageReceivedNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        MessageReceivedModel messageModel = (MessageReceivedModel)ctx.value(NotificationUtils.MESSAGE_RECEIVED_MODEL);
        NotificationInfo notification = NotificationInfo.instance();
        notification.key(this.getId());
        notification.to(messageModel.getReceivers());
        if (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty()) {
            return null;
        }
        notification.with("isGroupeChat", String.valueOf(messageModel.getReceivers().size() > 1));
        notification.with("roomId", String.valueOf(messageModel.getRoomId()));
        notification.with("sender", String.valueOf(messageModel.getSender()));
        notification.with("senderFullName", String.valueOf(messageModel.getSenderFullName()));
        notification.with("roomName", String.valueOf(messageModel.getRoomName()));
        notification.with("message", String.valueOf(messageModel.getMessage()));
        notification.with("chatUrl", NotificationUtils.getRoomURL(messageModel.getRoomId()));
        notification.with("avatar", "/portal/rest/v1/social/users/{}/avatar".replace("{}", messageModel.getSender()));
        return notification;
    }
}

