/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.rest;

import io.meeds.portal.security.model.RegistrationSetting;
import io.meeds.portal.security.service.SecuritySettingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/registration/settings")
@Tag(name="/registration/settings", description="Managing user registraion settings and flow")
public class RegistrationSettingRest
implements ResourceContainer {
    private SecuritySettingService securitySettingService;

    public RegistrationSettingRest(SecuritySettingService securitySettingService) {
        this.securitySettingService = securitySettingService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Get user registraion settings", description="Get user registraion settings", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getRegistrationSetting() {
        RegistrationSetting registrationSetting = this.securitySettingService.getRegistrationSetting();
        return Response.ok((Object)registrationSetting).build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Update user registraion settings and flow", description="Update user registraion settings and flow", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled")})
    public Response updateRegistrationSetting(RegistrationSetting registrationSetting) {
        this.securitySettingService.saveRegistrationSetting(registrationSetting);
        return Response.noContent().build();
    }
}

