/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class AgendaVotesNotificationListener
extends Listener<Long, Long> {
    private PortalContainer container;
    private AgendaEventService agendaEventService;

    public AgendaVotesNotificationListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Long, Long> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            long eventId = (Long)event.getSource();
            long identityId = (Long)event.getData();
            org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId);
            if (agendaEvent.getCreatorId() != identityId) {
                this.sendVoteNotification(agendaEvent, identityId, EventAttendeeResponse.TENTATIVE);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void sendVoteNotification(org.exoplatform.agenda.model.Event event, long participantId, EventAttendeeResponse response) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.EVENT_AGENDA, (Object)event);
        ctx.append(NotificationUtils.EVENT_PARTICIPANT_ID, (Object)participantId);
        ctx.append(NotificationUtils.EVENT_RESPONSE, (Object)response);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"VoteNotificationPlugin"))).execute(ctx);
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

